/*
 * Decompiled with CFR 0.152.
 */
package de.cenote.jasperstarter;

import de.cenote.jasperstarter.Config;
import de.cenote.jasperstarter.Report;
import de.cenote.jasperstarter.types.AskFilter;
import de.cenote.jasperstarter.types.Command;
import de.cenote.jasperstarter.types.DsType;
import de.cenote.jasperstarter.types.OutputFormat;
import de.cenote.tools.classpath.ApplicationClasspath;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class App {
    private Namespace namespace = null;
    private Map<String, Argument> allArguments = null;

    public static void main(String[] args) {
        Config config = new Config();
        App app = new App();
        ArgumentParser parser = app.createArgumentParser(config);
        if (args.length == 0) {
            System.out.println(parser.formatUsage());
            System.out.println("type: jasperstarter -h to get help");
            System.exit(0);
        }
        try {
            app.parseArgumentParser(args, parser, config);
        }
        catch (ArgumentParserException ex) {
            parser.handleError(ex);
            System.exit(1);
        }
        if (config.isVerbose()) {
            System.out.print("Command line:");
            for (String arg : args) {
                System.out.print(" " + arg);
            }
        }
        if (config.hasLocale()) {
            Locale.setDefault(config.getLocale());
        }
        try {
            switch (Command.getCommand(config.getCommand())) {
                case COMPILE: 
                case CP: {
                    app.compile(config);
                    break;
                }
                case PROCESS: 
                case PR: {
                    app.processReport(config);
                    break;
                }
                case LIST_PRINTERS: 
                case PRINTERS: 
                case LPR: {
                    app.listPrinters();
                    break;
                }
                case LIST_PARAMETERS: 
                case PARAMS: 
                case LPA: {
                    App.listReportParams(config, new File(config.getInput()).getAbsoluteFile());
                }
            }
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        catch (JRException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private void compile(Config config) {
        IllegalArgumentException error = null;
        File input = new File(config.getInput());
        if (input.isFile()) {
            try {
                Report report = new Report(config, input);
                report.compileToFile();
            }
            catch (IllegalArgumentException ex) {
                error = ex;
            }
        } else if (input.isDirectory()) {
            File[] files;
            WildcardFileFilter fileFilter = new WildcardFileFilter("*.jrxml", IOCase.INSENSITIVE);
            for (File file : files = input.listFiles((FileFilter)fileFilter)) {
                try {
                    System.out.println("Compiling: \"" + file + "\"");
                    Report report = new Report(config, file);
                    report.compileToFile();
                }
                catch (IllegalArgumentException ex) {
                    error = ex;
                }
            }
        } else {
            error = new IllegalArgumentException("Error: not a file: " + input.getName());
        }
        if (error != null) {
            throw error;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processReport(Config config) throws IllegalArgumentException, InterruptedException, JRException {
        try {
            if (config.hasJdbcDir()) {
                File jdbcDir = config.getJdbcDir();
                if (config.isVerbose()) {
                    System.out.println("Using jdbc-dir: " + jdbcDir.getAbsolutePath());
                }
                ApplicationClasspath.addJars(jdbcDir.getAbsolutePath());
            } else {
                ApplicationClasspath.addJarsRelative("../jdbc");
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error adding jdbc-dir", ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Error adding jdbc-dir: \"../jdbc\"", ex);
        }
        if (config.hasResource()) {
            try {
                File res;
                if ("".equals(config.getResource())) {
                    res = new File(config.getInput()).getAbsoluteFile().getParentFile();
                    if (!res.isDirectory()) throw new IllegalArgumentException("Resource path \"" + res + "\" is not a directory");
                    ApplicationClasspath.add(res);
                    if (config.isVerbose()) {
                        System.out.println("Added resource \"" + res + "\" to classpath");
                    }
                } else {
                    res = new File(config.getResource());
                    ApplicationClasspath.add(res);
                    if (config.isVerbose()) {
                        System.out.println("Added resource \"" + res + "\" to classpath");
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Error adding resource \"" + config.getResource() + "\" to classpath", ex);
            }
        }
        File inputFile = new File(config.getInput()).getAbsoluteFile();
        if (config.isVerbose()) {
            System.out.println("Original input file: " + inputFile.getAbsolutePath());
        }
        inputFile = this.locateInputFile(inputFile);
        if (config.isVerbose()) {
            System.out.println("Using input file: " + inputFile.getAbsolutePath());
        }
        Report report = new Report(config, inputFile);
        report.fill();
        List<OutputFormat> formats = config.getOutputFormats();
        Boolean viewIt = false;
        Boolean printIt = false;
        for (OutputFormat f : formats) {
            if (OutputFormat.print.equals((Object)f)) {
                printIt = true;
                continue;
            }
            if (OutputFormat.view.equals((Object)f)) {
                viewIt = true;
                continue;
            }
            if (OutputFormat.pdf.equals((Object)f)) {
                report.exportPdf();
                continue;
            }
            if (OutputFormat.docx.equals((Object)f)) {
                report.exportDocx();
                continue;
            }
            if (OutputFormat.odt.equals((Object)f)) {
                report.exportOdt();
                continue;
            }
            if (OutputFormat.rtf.equals((Object)f)) {
                report.exportRtf();
                continue;
            }
            if (OutputFormat.html.equals((Object)f)) {
                report.exportHtml();
                continue;
            }
            if (OutputFormat.xml.equals((Object)f)) {
                report.exportXml();
                continue;
            }
            if (OutputFormat.xls.equals((Object)f)) {
                report.exportXls();
                continue;
            }
            if (OutputFormat.xlsMeta.equals((Object)f)) {
                report.exportXlsMeta();
                continue;
            }
            if (OutputFormat.xlsx.equals((Object)f)) {
                report.exportXlsx();
                continue;
            }
            if (OutputFormat.csv.equals((Object)f)) {
                report.exportCsv();
                continue;
            }
            if (OutputFormat.csvMeta.equals((Object)f)) {
                report.exportCsvMeta();
                continue;
            }
            if (OutputFormat.ods.equals((Object)f)) {
                report.exportOds();
                continue;
            }
            if (OutputFormat.pptx.equals((Object)f)) {
                report.exportPptx();
                continue;
            }
            if (OutputFormat.xhtml.equals((Object)f)) {
                report.exportXhtml();
                continue;
            }
            if (OutputFormat.jrprint.equals((Object)f)) continue;
            throw new IllegalArgumentException("Error output format \"" + (Object)((Object)f) + "\" not implemented!");
        }
        if (viewIt.booleanValue()) {
            report.view();
            return;
        } else {
            if (!printIt.booleanValue()) return;
            report.print();
        }
    }

    private File locateInputFile(File inputFile) {
        if (!inputFile.exists()) {
            File newInputfile = new File(inputFile.getAbsolutePath() + ".jasper");
            if (newInputfile.isFile()) {
                inputFile = newInputfile;
            }
            if (!inputFile.exists() && (newInputfile = new File(inputFile.getAbsolutePath() + ".jrxml")).isFile()) {
                inputFile = newInputfile;
            }
        }
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("Error: file not found: " + inputFile.getAbsolutePath());
        }
        if (inputFile.isDirectory()) {
            throw new IllegalArgumentException("Error: " + inputFile.getAbsolutePath() + " is a directory, file needed");
        }
        return inputFile;
    }

    private void listPrinters() {
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        System.out.println("Default printer:");
        System.out.println("-----------------");
        System.out.println(defaultService == null ? "--- not set ---" : defaultService.getName());
        System.out.println("");
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        System.out.println("Available printers:");
        System.out.println("--------------------");
        for (PrintService service : services) {
            System.out.println(service.getName());
        }
    }

    private ArgumentParser createArgumentParser(Config config) {
        this.allArguments = new HashMap<String, Argument>();
        ArgumentParser parser = ArgumentParsers.newArgumentParser("jasperstarter", false, "-", "@").version(config.getVersionString());
        parser.addArgument("-h", "--help").action(Arguments.help()).help("show this help message and exit");
        parser.addArgument("--locale").dest("locale").metavar("<lang>").help("set locale with two-letter ISO-639 code or a combination of ISO-639 and ISO-3166 like de_DE");
        parser.addArgument("-v", "--verbose").dest("debug").action(Arguments.storeTrue()).help("display additional messages");
        parser.addArgument("-V", "--version").action(Arguments.version()).help("display version information and exit");
        Subparsers subparsers = parser.addSubparsers().title("commands").help("type <cmd> -h to get help on command").metavar("<cmd>").dest("command");
        Subparser parserCompile = subparsers.addParser("compile", true).aliases("cp").help("compile reports");
        this.createCompileArguments(parserCompile);
        Subparser parserProcess = subparsers.addParser("process", true).aliases("pr").help("view, print or export an existing report");
        this.createProcessArguments(parserProcess);
        Subparser parserListPrinters = subparsers.addParser("list_printers", true).aliases("printers", "lpr").help("lists available printers");
        Subparser parserListParams = subparsers.addParser("list_parameters", true).aliases("params", "lpa").help("list parameters from a given report");
        this.createListParamsArguments(parserListParams);
        return parser;
    }

    private void createCompileArguments(Subparser parser) {
        ArgumentGroup groupOptions = parser.addArgumentGroup("options");
        groupOptions.addArgument("input").metavar("<input>").dest("input").required(true).help("input file (.jrxml) or directory");
        groupOptions.addArgument("-o").metavar("<output>").dest("output").help("directory or basename of outputfile(s)");
    }

    private void createListParamsArguments(Subparser parser) {
        ArgumentGroup groupOptions = parser.addArgumentGroup("options");
        groupOptions.addArgument("input").metavar("<input>").dest("input").required(true).help("input file (.jrxml) or (.jasper)");
    }

    private void createProcessArguments(Subparser parser) {
        ArgumentGroup groupOptions = parser.addArgumentGroup("options");
        groupOptions.addArgument("-f").metavar("<fmt>").dest("output-formats").required(true).nargs("+").type(Arguments.enumType(OutputFormat.class)).help("view, print, pdf, rtf, xls, xlsMeta, xlsx, docx, odt, ods, pptx, csv, csvMeta, html, xhtml, xml, jrprint");
        groupOptions.addArgument("input").metavar("<input>").dest("input").required(true).help("input file (.jrxml|.jasper|.jrprint)");
        groupOptions.addArgument("-o").metavar("<output>").dest("output").help("directory or basename of outputfile(s)");
        ArgumentGroup groupCompileOptions = parser.addArgumentGroup("compile options");
        groupCompileOptions.addArgument("-w", "--write-jasper").dest("write-jasper").action(Arguments.storeTrue()).help("write .jasper file to imput dir if jrxml is processed");
        ArgumentGroup groupFillOptions = parser.addArgumentGroup("fill options");
        groupFillOptions.addArgument("-a").metavar("<filter>").dest("ask").type(Arguments.enumType(AskFilter.class)).nargs("?").setConst((Object)AskFilter.p).help("ask for report parameters. Filter: a, ae, u, ue, p, pe (see usage)");
        groupFillOptions.addArgument("-P").metavar("<param>").dest("params").nargs("+").help("report parameter: name=value [...]");
        groupFillOptions.addArgument("-r").metavar("<resource>").dest("resource").nargs("?").setConst("").help("path to report resource dir or jar file. If <resource> is not given the input directory is used.");
        ArgumentGroup groupDatasourceOptions = parser.addArgumentGroup("datasource options");
        groupDatasourceOptions.addArgument("-t").metavar("<dstype>").dest("db-type").required(false).type(Arguments.enumType(DsType.class)).setDefault((Object)DsType.none).help("datasource type: none, csv, xml, json, mysql, postgres, oracle, generic (jdbc)");
        Argument argDbHost = groupDatasourceOptions.addArgument("-H").metavar("<dbhost>").dest("db-host").help("database host");
        Argument argDbUser = groupDatasourceOptions.addArgument("-u").metavar("<dbuser>").dest("db-user").help("database user");
        Argument argDbPasswd = groupDatasourceOptions.addArgument("-p").metavar("<dbpasswd>").dest("db-passwd").setDefault("").help("database password");
        Argument argDbName = groupDatasourceOptions.addArgument("-n").metavar("<dbname>").dest("db-name").help("database name");
        Argument argDbSid = groupDatasourceOptions.addArgument("--db-sid").metavar("<sid>").dest("db-sid").help("oracle sid");
        Argument argDbPort = groupDatasourceOptions.addArgument("--db-port").metavar("<port>").dest("db-port").type(Integer.class).help("database port");
        Argument argDbDriver = groupDatasourceOptions.addArgument("--db-driver").metavar("<name>").dest("db-driver").help("jdbc driver class name for use with type: generic");
        Argument argDbUrl = groupDatasourceOptions.addArgument("--db-url").metavar("<jdbcUrl>").dest("db-url").help("jdbc url without user, passwd with type:generic");
        groupDatasourceOptions.addArgument("--jdbc-dir").metavar("<dir>").dest("jdbc-dir").type(File.class).help("directory where jdbc driver jars are located. Defaults to ./jdbc");
        Argument argDataFile = groupDatasourceOptions.addArgument("--data-file").metavar("<file>").dest("data-file").type(File.class).help("input file for file based datasource");
        groupDatasourceOptions.addArgument("--csv-first-row").metavar("true", "false").dest("csv-first-row").action(Arguments.storeTrue()).help("first row contains column headers");
        Argument argCsvColumns = groupDatasourceOptions.addArgument("--csv-columns").metavar("<list>").dest("csv-columns").help("Comma separated list of column names");
        groupDatasourceOptions.addArgument("--csv-record-del").metavar("<delimiter>").dest("csv-record-del").setDefault(System.getProperty("line.separator")).help("CSV Record Delimiter - defaults to line.separator");
        groupDatasourceOptions.addArgument("--csv-field-del").metavar("<delimiter>").dest("csv-field-del").setDefault(",").help("CSV Field Delimiter - defaults to \",\"");
        groupDatasourceOptions.addArgument("--csv-charset").metavar("<charset>").dest("csv-charset").setDefault("utf-8").help("CSV charset - defaults to \"utf-8\"");
        Argument argXmlXpath = groupDatasourceOptions.addArgument("--xml-xpath").metavar("<xpath>").dest("xml-xpath").help("XPath for XML Datasource");
        Argument argJsonQuery = groupDatasourceOptions.addArgument("--json-query").metavar("<jsonquery>").dest("json-query").help("JSON query string for JSON Datasource");
        ArgumentGroup groupOutputOptions = parser.addArgumentGroup("output options");
        groupOutputOptions.addArgument("-N").metavar("<printername>").dest("printer-name").help("name of printer");
        groupOutputOptions.addArgument("-d").dest("with-print-dialog").action(Arguments.storeTrue()).help("show print dialog when printing");
        groupOutputOptions.addArgument("-s").metavar("<reportname>").dest("set-report-name").help("set internal report/document name when printing");
        groupOutputOptions.addArgument("-c").metavar("<copies>").dest("copies").type(Integer.class).choices(Arguments.range(1, Integer.MAX_VALUE)).help("number of copies. Defaults to 1");
        groupOutputOptions.addArgument("--out-field-del").metavar("<delimiter>").dest("out-field-del").setDefault(",").help("Export CSV (Metadata) Field Delimiter - defaults to \",\"");
        groupOutputOptions.addArgument("--out-charset").metavar("<charset>").dest("out-charset").setDefault("utf-8").help("Export CSV (Metadata) Charset - defaults to \"utf-8\"");
        this.allArguments.put(argDbHost.getDest(), argDbHost);
        this.allArguments.put(argDbUser.getDest(), argDbUser);
        this.allArguments.put(argDbPasswd.getDest(), argDbPasswd);
        this.allArguments.put(argDbName.getDest(), argDbName);
        this.allArguments.put(argDbSid.getDest(), argDbSid);
        this.allArguments.put(argDbPort.getDest(), argDbPort);
        this.allArguments.put(argDbDriver.getDest(), argDbDriver);
        this.allArguments.put(argDbUrl.getDest(), argDbUrl);
        this.allArguments.put(argDataFile.getDest(), argDataFile);
        this.allArguments.put(argCsvColumns.getDest(), argCsvColumns);
        this.allArguments.put(argXmlXpath.getDest(), argXmlXpath);
        this.allArguments.put(argJsonQuery.getDest(), argJsonQuery);
    }

    private void parseArgumentParser(String[] args, ArgumentParser parser, Config config) throws ArgumentParserException {
        parser.parseArgs(args, config);
        if (config.hasDbType() && !config.getDbType().equals((Object)DsType.none)) {
            if (config.getDbType().equals((Object)DsType.mysql)) {
                this.allArguments.get("db-host").required(true);
                this.allArguments.get("db-user").required(true);
                this.allArguments.get("db-name").required(true);
                this.allArguments.get("db-port").setDefault(DsType.mysql.getPort());
            } else if (config.getDbType().equals((Object)DsType.postgres)) {
                this.allArguments.get("db-host").required(true);
                this.allArguments.get("db-user").required(true);
                this.allArguments.get("db-name").required(true);
                this.allArguments.get("db-port").setDefault(DsType.postgres.getPort());
            } else if (config.getDbType().equals((Object)DsType.oracle)) {
                this.allArguments.get("db-host").required(true);
                this.allArguments.get("db-user").required(true);
                this.allArguments.get("db-passwd").required(true);
                this.allArguments.get("db-sid").required(true);
                this.allArguments.get("db-port").setDefault(DsType.oracle.getPort());
            } else if (config.getDbType().equals((Object)DsType.generic)) {
                this.allArguments.get("db-driver").required(true);
                this.allArguments.get("db-url").required(true);
            } else if (DsType.csv.equals((Object)config.getDbType())) {
                this.allArguments.get("data-file").required(true);
                if (!config.getCsvFirstRow()) {
                    this.allArguments.get("csv-columns").required(true);
                }
            } else if (DsType.xml.equals((Object)config.getDbType())) {
                this.allArguments.get("data-file").required(true);
                this.allArguments.get("xml-xpath").required(true);
            } else if (DsType.json.equals((Object)config.getDbType())) {
                this.allArguments.get("data-file").required(true);
                this.allArguments.get("json-query").required(true);
            }
        }
        parser.parseArgs(args, config);
    }

    public static void listReportParams(Config config, File input) throws IllegalArgumentException {
        Report report = new Report(config, input);
        JRParameter[] params = report.getReportParameters();
        int maxName = 1;
        int maxClassName = 1;
        int maxDesc = 1;
        boolean all = false;
        for (JRParameter param : params) {
            if (param.isSystemDefined() && !all) continue;
            if (param.getName() != null) {
                maxName = Math.max(maxName, param.getName().length());
            }
            if (param.getValueClassName() != null) {
                maxClassName = Math.max(maxClassName, param.getValueClassName().length());
            }
            if (param.getDescription() == null) continue;
            maxDesc = Math.max(maxDesc, param.getDescription().length());
        }
        for (JRParameter param : params) {
            if (param.isSystemDefined() && !all) continue;
            System.out.printf("%s %-" + maxName + "s %-" + maxClassName + "s %-" + maxDesc + "s %n", param.isForPrompting() ? "P" : "N", param.getName(), param.getValueClassName(), param.getDescription() != null ? param.getDescription() : "");
        }
    }
}

