/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.OoxmlUtils;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.type.PaperSizeEnum;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.export.XlsReportConfiguration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class XlsxSheetHelper
extends BaseHelper {
    private int rowIndex;
    private FileBufferedWriter colsWriter = new FileBufferedWriter();
    private FileBufferedWriter mergedCellsWriter = new FileBufferedWriter();
    private FileBufferedWriter hyperlinksWriter = new FileBufferedWriter();
    private XlsxSheetRelsHelper sheetRelsHelper;
    private final XlsReportConfiguration configuration;
    private List<Integer> rowBreaks = new ArrayList<Integer>();

    public XlsxSheetHelper(JasperReportsContext jasperReportsContext, Writer writer, XlsxSheetRelsHelper sheetRelsHelper, XlsReportConfiguration configuration) {
        super(jasperReportsContext, writer);
        this.sheetRelsHelper = sheetRelsHelper;
        this.configuration = configuration;
    }

    public void exportHeader(boolean showGridlines, int scale, int rowFreezeIndex, int columnFreezeIndex, int maxColumnFreezeIndex, JasperPrint jasperPrint, Color tabColor) {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<worksheet\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        this.write("<sheetPr>\n");
        if (tabColor != null) {
            this.write("<tabColor rgb=\"FF" + JRColorUtil.getColorHexa(tabColor) + "\"/>\n");
        }
        this.write("<outlinePr summaryBelow=\"0\"/>\n");
        if (!(scale >= 10 && scale <= 400 || this.configuration.getFitWidth() == null && this.configuration.getFitHeight() == null && Boolean.TRUE != this.configuration.isAutoFitPageHeight())) {
            this.write("<pageSetUpPr fitToPage=\"1\"/>");
        }
        this.write("</sheetPr><dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"");
        if (!showGridlines) {
            this.write(" showGridLines=\"0\"");
        }
        if (rowFreezeIndex > 0 || columnFreezeIndex > 0) {
            this.write(">\n<pane" + (columnFreezeIndex > 0 ? " xSplit=\"" + columnFreezeIndex + "\"" : "") + (rowFreezeIndex > 0 ? " ySplit=\"" + rowFreezeIndex + "\"" : ""));
            String columnFreezeName = columnFreezeIndex < 0 ? "A" : JRXlsAbstractExporter.getColumIndexName(columnFreezeIndex, maxColumnFreezeIndex);
            this.write(" topLeftCell=\"" + columnFreezeName + (rowFreezeIndex + 1) + "\"");
            String activePane = (rowFreezeIndex > 0 ? "bottom" : "top") + (columnFreezeIndex > 0 ? "Right" : "Left");
            this.write(" activePane=\"" + activePane + "\" state=\"frozen\"/>\n");
            this.write("<selection pane=\"" + activePane + "\"");
            this.write(" activeCell=\"" + columnFreezeName + (rowFreezeIndex + 1) + "\"");
            this.write(" sqref=\"" + columnFreezeName + (rowFreezeIndex + 1) + "\"");
            this.write("/>\n");
            this.write("</sheetView>\n</sheetViews>\n");
        } else {
            this.write("/></sheetViews>\n");
        }
        this.write("<sheetFormatPr defaultRowHeight=\"15\"/>\n");
    }

    public void exportFooter(int index, PrintPageFormat jasperPrint, boolean isIgnorePageMargins, String autoFilter, Integer scale, Integer firstPageNumber, boolean firstPageNotSet, Integer sheetPageCount) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        this.write("</sheetData>\n");
        if (autoFilter != null) {
            this.write("<autoFilter ref=\"" + autoFilter + "\"/>\n");
        }
        if (!this.mergedCellsWriter.isEmpty()) {
            this.write("<mergeCells>\n");
            this.mergedCellsWriter.writeData(this.writer);
            this.write("</mergeCells>\n");
        }
        if (!this.hyperlinksWriter.isEmpty()) {
            this.write("<hyperlinks>\n");
            this.hyperlinksWriter.writeData(this.writer);
            this.write("</hyperlinks>\n");
        }
        this.write("<pageMargins left=\"");
        this.write("0");
        this.write("\" right=\"");
        this.write("0");
        this.write("\" top=\"");
        this.write("0");
        this.write("\" bottom=\"");
        this.write("0");
        this.write("\" header=\"0.0\" footer=\"0.0\"/>\n");
        this.write("<pageSetup");
        if (jasperPrint.getOrientation() != null) {
            this.write(" orientation=\"" + jasperPrint.getOrientation().getName().toLowerCase() + "\"");
        }
        if (scale != null && scale > 9 && scale < 401) {
            this.write(" scale=\"" + scale + "\"");
        } else {
            Integer fitHeight;
            Integer fitWidth = this.configuration.getFitWidth();
            if (fitWidth != null && fitWidth != 1) {
                this.write(" fitToWidth=\"" + fitWidth + "\"");
            }
            Integer n = (fitHeight = this.configuration.getFitHeight()) == null ? (Boolean.TRUE == this.configuration.isAutoFitPageHeight() ? sheetPageCount : null) : (fitHeight = fitHeight);
            if (fitHeight != null && fitHeight != 1) {
                this.write(" fitToHeight=\"" + fitHeight + "\"");
            }
        }
        PaperSizeEnum pSize = OoxmlUtils.getSuitablePaperSize(jasperPrint);
        String paperSize = pSize == PaperSizeEnum.UNDEFINED ? "" : " paperSize=\"" + pSize.getOoxmlValue() + "\"";
        this.write(paperSize);
        if (firstPageNumber != null && firstPageNumber > 0) {
            this.write(" firstPageNumber=\"" + firstPageNumber + "\"");
            this.write(" useFirstPageNumber=\"1\"/>\n");
        } else {
            this.write("/>\n");
        }
        if (this.rowBreaks.size() > 0) {
            this.write("<rowBreaks count=\"" + this.rowBreaks.size() + "\" manualBreakCount=\"" + this.rowBreaks.size() + "\">");
            for (Integer rowBreakIndex : this.rowBreaks) {
                this.write("<brk id=\"" + (rowBreakIndex + 1) + "\" man=\"1\"/>");
            }
            this.write("</rowBreaks>");
        }
        if (this.hasHeaderOrFooter()) {
            this.write("<headerFooter>");
            if (this.hasHeader()) {
                this.write("<oddHeader>");
                if (StringUtils.isNotBlank((String)this.configuration.getSheetHeaderLeft())) {
                    this.write("&amp;L");
                    this.write(StringEscapeUtils.escapeHtml((String)this.configuration.getSheetHeaderLeft()));
                }
                if (StringUtils.isNotBlank((String)this.configuration.getSheetHeaderCenter())) {
                    this.write("&amp;C");
                    this.write(StringEscapeUtils.escapeHtml((String)this.configuration.getSheetHeaderCenter()));
                }
                if (StringUtils.isNotBlank((String)this.configuration.getSheetHeaderRight())) {
                    this.write("&amp;R");
                    this.write(StringEscapeUtils.escapeHtml((String)this.configuration.getSheetHeaderRight()));
                }
                this.write("</oddHeader>");
            }
            if (this.hasFooter()) {
                this.write("<oddFooter>");
                if (StringUtils.isNotBlank((String)this.configuration.getSheetFooterLeft())) {
                    this.write("&amp;L");
                    this.write(StringEscapeUtils.escapeHtml((String)this.configuration.getSheetFooterLeft()));
                }
                if (StringUtils.isNotBlank((String)this.configuration.getSheetFooterCenter())) {
                    this.write("&amp;C");
                    this.write(StringEscapeUtils.escapeHtml((String)this.configuration.getSheetFooterCenter()));
                }
                if (StringUtils.isNotBlank((String)this.configuration.getSheetFooterRight())) {
                    this.write("&amp;R");
                    this.write(StringEscapeUtils.escapeHtml((String)this.configuration.getSheetFooterRight()));
                }
                this.write("</oddFooter>");
            }
            this.write("</headerFooter>");
        }
        if (!firstPageNotSet) {
            this.write("<headerFooter><oddFooter>Page &amp;P</oddFooter></headerFooter>\n");
        }
        this.write("<drawing r:id=\"rIdDr" + index + "\"/>");
        this.write("</worksheet>");
    }

    private boolean hasHeaderOrFooter() {
        return this.hasHeader() || this.hasFooter();
    }

    private boolean hasHeader() {
        return StringUtils.isNotBlank((String)this.configuration.getSheetHeaderLeft()) || StringUtils.isNotBlank((String)this.configuration.getSheetHeaderCenter()) || StringUtils.isNotBlank((String)this.configuration.getSheetHeaderRight());
    }

    private boolean hasFooter() {
        return StringUtils.isNotBlank((String)this.configuration.getSheetFooterLeft()) || StringUtils.isNotBlank((String)this.configuration.getSheetFooterCenter()) || StringUtils.isNotBlank((String)this.configuration.getSheetFooterRight());
    }

    public void exportColumn(int colIndex, int colWidth, boolean autoFit) {
        try {
            this.colsWriter.write("<col min=\"" + (colIndex + 1) + "\" max=\"" + (colIndex + 1) + "\"" + (autoFit ? " customWidth=\"0\" bestFit=\"1\"" : " customWidth=\"1\"") + " width=\"" + 3.0f * (float)colWidth / 18.0f + "\"/>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void exportRow(int rowHeight, Cut yCut, XlsRowLevelInfo levelInfo) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        ++this.rowIndex;
        boolean isAutoFit = yCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row") && (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") != false;
        this.write("<row r=\"" + this.rowIndex + "\"" + (isAutoFit ? " customHeight=\"0\" bestFit=\"1\"" : " customHeight=\"1\"") + " ht=\"" + rowHeight + "\"");
        if (levelInfo.getLevelMap().size() > 0) {
            this.write(" outlineLevel=\"" + levelInfo.getLevelMap().size() + "\"");
        }
        this.write(">\n");
    }

    public void exportMergedCells(int row, int col, int maxColumnIndex, int rowSpan, int colSpan) {
        int n = rowSpan = this.configuration.isCollapseRowSpan() != false ? 1 : rowSpan;
        if (rowSpan > 1 || colSpan > 1) {
            String ref = JRXlsAbstractExporter.getColumIndexName(col, maxColumnIndex) + (row + 1) + ":" + JRXlsAbstractExporter.getColumIndexName(col + colSpan - 1, maxColumnIndex) + (row + rowSpan);
            try {
                this.mergedCellsWriter.write("<mergeCell ref=\"" + ref + "\"/>\n");
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public void exportHyperlink(int row, int col, int maxColumnIndex, String href, boolean isLocal) {
        String ref = JRXlsAbstractExporter.getColumIndexName(col, maxColumnIndex) + (row + 1);
        try {
            if (isLocal) {
                this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" location=\"" + (href == null ? null : href.replaceAll("\\W", "")) + "\"/>\n");
            } else {
                this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" r:id=\"rIdLnk" + this.sheetRelsHelper.getHyperlink(href) + "\"/>\n");
            }
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void addRowBreak(int rowIndex) {
        this.rowBreaks.add(rowIndex);
    }
}

