﻿

//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  T�TULO: omnisoftjqxComboBox.js
//  DESCRIPCI�N: Archivo que contiene la clase omnisoftjqxComboBox para la gestion de base de datos
//  FECHA DE CREACI�N: 15-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCI�N
//  1) ------------- -------------  -------------------------


omnisoftjqxCalendar=function(aObjName,afieldname,aTheme,sWidth,aValue,aOnChange) {

 this.objName='#'+aObjName;
 this.jqxcalendar=$(this.objName);
 this.theme=aTheme;
 this.fieldname=afieldname;
 this.width=sWidth;
 this.onchange=(aOnChange==undefined)?'':aOnChange;
 this.value=(aValue==undefined)?'':aValue;

 this.show=function() {
   var calObj=this;
   this.jqxcalendar.jqxDateTimeInput({width: this.width, height: '25px', theme: this.theme, formatString: "yyyy-MM-dd" ,todayString: 'Today' });

   if (this.value!='')
       this.setDate(this.value);

   this.jqxcalendar.on('change', function (event) {
          var date1 = event.args.date;
          //alert('event='+event.args.date);
          if (date1==null)
              date1=new Date(0,0,0);
            //  alert(date1);
		  var date2=date1.getFullYear()+'-'+(date1.getMonth()+1)+'-'+ date1.getDate();
          document.getElementById(calObj.fieldname).value=date2;

   });


 } //show

 this.setDate=function(pdate) {
   var fecha=pdate.split("-");
   //alert('calendar='+pdate);
  this.jqxcalendar.jqxDateTimeInput('setDate', new Date(fecha[0], fecha[1]-1, fecha[2]));
 }

}


function fechaSistema(){

var hoy= new Date();

var mes=hoy.getMonth()+1;
var year= (hoy.getYear()<=1900) ? hoy.getYear()+1900:hoy.getYear();
var sfecha = year + '-' + ((mes<10)?'0'+mes:mes) + '-' + ((hoy.getDate()<10)?'0'+hoy.getDate():hoy.getDate());

return sfecha;

}

function date2UTCDate(pfecha) {
   var fecha=new Date(pfecha);
   return fecha.getUTCFullYear()+'-'+(fecha.getUTCMonth()+1)+'-'+fecha.getUTCDate();
}


function asignarFecha(pfecha, pomniObj) {
   if ((pfecha=='0000-00-00') || (pfecha==""))
   		pfecha=fechaSistema();
   else
   	    pfecha=date2UTCDate(pfecha);

	pomniObj.setDate(pfecha);
}