﻿
//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  T�TULO: omnisoftjqxComboBox.js
//  DESCRIPCI�N: Archivo que contiene la clase omnisoftjqxComboBox para la gestion de base de datos
//  FECHA DE CREACI�N: 15-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCI�N
//  1) ------------- -------------  -------------------------



omnisoftjqxComboBox=function(aObjName,afieldname,aTheme,aSQLCommand,sWidth,aValue,aAll,aOnChange) {
 this.objName='#'+aObjName;
 this.jqxcombobox=$(this.objName);
 this.theme=aTheme;
 this.SQLCommand=aSQLCommand;
 this.fieldname=afieldname;
 this.width=sWidth;
 this.seleccion=(aAll==undefined)?'':aAll;
 this.onchange=(aOnChange==undefined)?'':aOnChange;
 this.value=(aValue==undefined)?'':aValue;
   this.source=new Array();
   this.source.sql='sql';
   this.dataAdapter;
   this.maxrows=100;
   this.datafield=new Array();
   this.datafieldCount=0;
   this.params;
   this.inicial=1;
   this.searching=false;

 this.build=function() {
     var slist=this.SQLCommand.split('FROM')[0];
     var scolumnlist=slist.substring(7,slist.length);
     var columnlist=scolumnlist.split(',');

	 var columnName='';
     for (this.datafieldCount=0;this.datafieldCount<columnlist.length;this.datafieldCount++) {
	     columnName=columnlist[this.datafieldCount].split(' as ');
	     if (columnName.length>1) {

this.datafield[this.datafieldCount]={ name: columnName[1].replace(/\s/g,'')};
		 }
else
     this.datafield[this.datafieldCount]={ name: columnlist[this.datafieldCount].replace(/\s/g,'')};
	 }
 }


this.selectItem=function() {
   var  cbxObject=this;

    var item = cbxObject.jqxcombobox.jqxComboBox('getItemByValue', cbxObject.value);
               if (item!=undefined)
                   cbxObject.jqxcombobox.jqxComboBox('selectItem', item);

}

this.selectItemByValue=function(value) {
   var  cbxObject=this;

    var item = cbxObject.jqxcombobox.jqxComboBox('getItemByValue',value);

               if (item!='' )
               cbxObject.jqxcombobox.jqxComboBox('selectItem', item);



}


this.selectFirstItem=function() {
   var  cbxObject=this;
               cbxObject.jqxcombobox.jqxComboBox('selectIndex', 0);

 }






  this.setQuery=function(newquery,pvalue=0) {
    var cbxObject=this;
    cbxObject.SQLCommand=newquery;
    cbxObject.value=pvalue;
 //   cbxObject.value=(pvalue!=undefined)?pvalue:0;

    cbxObject.dataAdapter.dataBind();
//    cbxObject.jqxcombobox.jqxComboBox('selectIndex', 0 );

  }

  this.setDisabled=function(option) {
    var cbxObject=this;
    cbxObject.jqxcombobox.jqxComboBox({ disabled: option });
  }

  this.executeQuery=function(pvalue) {
    var cbxObject=this;
    cbxObject.value=pvalue;
    cbxObject.searching=false;
 //   alert(cbxObject.dataAdapter.source.data);
   cbxObject.dataAdapter.dataBind();

//   alert('entro');
 //  cbxObject.jqxcombobox.jqxComboBox('selectIndex', value);

  }


 this.show=function() {

   var  cbxObject=this;
       cbxObject.searching=false;
   this.build();
  this.source =  {

                             datatype: "json",
                             datafields:cbxObject.datafield,
                             id: cbxObject.fieldname,
                             url: 'lib/server/omnisoftComboJSON.php',
                             type:"GET",
                             root:"Rows",
                             record:"content",
                             processdata: function (data) {
                             data.query = cbxObject.SQLCommand;
                             },
                data: {
                    featureClass: "P",
                    style: "full",
                    maxRows: 50,
                    fieldname:cbxObject.fieldname,
                    value:cbxObject.value
                }

   };


this.dataAdapter = new $.jqx.dataAdapter(cbxObject.source,
{                   autoBind: true,
                    formatData: function (data) {
                        data.name_startsWith = cbxObject.jqxcombobox.jqxComboBox('searchString');
                        return data;
                    },

    loadServerData: function (serverdata, source, callback) {
        $.ajax({
            dataType:'json',
                             url: "lib/server/omnisoftComboJSON.php",
                             type:"GET",
            contentType: "application/json; charset=utf-8",
            data: serverdata,
success: function (data, status, xhr) {
                var xmldata = data[0].Rows;

                if (!xmldata) {
                    xmldata = [];
                }
                var dataArray = new Array();
                for (var i = 0; i < xmldata.length; i++) {
                    var record = xmldata[i];
                    var datarow = {};
                    for (var j = 0; j < source.datafields.length; j++) {
                        var datafield = source.datafields[j];
                        var value = '';
                        if (undefined == datafield || datafield == null) {
                            continue;
                        }

                        //value=record[datafield.name];
                   /*     if (datafield.map) {
                            value = $(datafield.map, record).text();
                        }
                        // searches by both selectors when necessary.
                        if (value == '') {
                            value = $(datafield.name, record).text();
                        }    */
//                        alert(record[datafield.name]);
                        datarow[datafield.name] = record[datafield.name];
                    }
                    dataArray[dataArray.length] = datarow;
                }
                // send the loaded records to the jqxDataAdapter plug-in.          
                callback({ records: dataArray });
            }

                    });
    }
}
);


   this.params=         {
                width: cbxObject.width,
                itemHeight:20,
                autoDropDownHeight: false,
                remoteAutoComplete: true,
                remoteAutoCompleteDelay: 500,
                source: cbxObject.dataAdapter,
               // searchmode:'startsWidth',
                theme: cbxObject.theme,
                displayMember: cbxObject.datafield[1].name,
                valueMember: cbxObject.datafield[0].name,
                renderer: function (index, label, value) {
                    var item = cbxObject.dataAdapter.records[index];
                    //alert(item.serial_paralu+' '+item.nombre_alu);
                    if (item != null) {
                      var label="";
		      var len = (cbxObject.datafield.length>3)? 3:cbxObject.datafield.length;
                      for(var i=1; i<len-1;i++)  {
                        label += "item."+cbxObject.datafield[i].name+ "+' '+" ;

                      }

                        label += "item."+cbxObject.datafield[i].name ;
                   //     label += "item."+cbxObject.datafield[1].name ;

                        label=eval(label);
                        //alert("valor="+value+" parametro= "+cbxObject.value);
                        if (value==cbxObject.value)
                           cbxObject.jqxcombobox.jqxComboBox('selectIndex', index);

                        //alert(label);
                        return label;

                    }

                    return "";
                }
 ,

                renderSelectedItem: function(index, item)
                {

                    var item = cbxObject.dataAdapter.records[index];
				//	alert('seleccion='+item+index);
                    if (item != null) {
                      var label="";
                      var len = (cbxObject.datafield.length>4)? 4:cbxObject.datafield.length;
                      for(var i=1; i<len-1;i++)  {
                        label += "item."+cbxObject.datafield[i].name+ "+' '+" ;

                      }

                        label += "item."+cbxObject.datafield[i].name ;
                        //label = "item."+cbxObject.datafield[1].name ;

                        label=eval(label);
                        var val=eval('item.'+cbxObject.fieldname);
                        //alert(cbxObject.fieldname+"="+val);
                        document.getElementById(cbxObject.fieldname).value=val;

                        //alert(label);
                        return label;
                    }
                    return "";
                },
                search: function (searchString) {
                  // alert(searchString);
                    cbxObject.dataAdapter.dataBind();
                },
            } ;
         cbxObject.jqxcombobox.jqxComboBox(this.params);

         $(cbxObject.objName).bind('select', function (event) {
	 //	alert('change');
                var index = cbxObject.jqxcombobox.jqxComboBox('getSelectedIndex');
                var item = cbxObject.dataAdapter.records[index];
                    if (item != null) {
                         var val=eval('item.'+cbxObject.fieldname);

                         document.getElementById(cbxObject.fieldname).value=val;
//						alert(cbxObject.fieldname+"="+val);

                         if (cbxObject.onchange!='')
                             setTimeout(cbxObject.onchange,0);

                    }
          });
          $(cbxObject.objName).on('bindingComplete', function (event) {
     //       alert(cbxObject.searching);
            if (cbxObject.searching==false) {

               var item = cbxObject.jqxcombobox.jqxComboBox('getItemByValue', cbxObject.value);

                if (item!=undefined && item!='')
                  cbxObject.jqxcombobox.jqxComboBox('selectItem', item);
                 else
                  cbxObject.jqxcombobox.jqxComboBox('selectIndex', 0);

             }
      cbxObject.searching=true;
      });


 } //show


}