﻿
//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  T�TULO: omnisoftjqxComboBox.js
//  DESCRIPCI�N: Archivo que contiene la clase omnisoftjqxComboBox para la gestion de base de datos
//  FECHA DE CREACI�N: 15-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCI�N
//  1) ------------- -------------  -------------------------



omnisoftjqxComboBoxSimple=function(aObjName,afieldname,aTheme,aSQLCommand,aFieldList,sWidth,aValue,aOnChange,aCheckBoxes) {
 this.objName='#'+aObjName;
 this.jqxcombobox=$(this.objName);
 this.theme=aTheme;
 this.SQLCommand=aSQLCommand;
 this.fieldname=afieldname;
 this.fieldlist=aFieldList;
 this.width=sWidth;
 this.onchange=(aOnChange==undefined)?'':aOnChange;
 this.value=(aValue==undefined)?'':aValue;
 this.currentValue=0;
 this.checkboxes=(aCheckBoxes==undefined)?false:aCheckBoxes;

   this.source=new Array();
   this.source.sql='sql';
   this.dataAdapter;
   this.maxrows=100;
   this.datafield=new Array();
   this.datafieldCount=0;
   this.params;
   this.inicial=1;

 this.build=function() {
     for (this.datafieldCount=0;this.datafieldCount<this.fieldlist.length;this.datafieldCount++)
         this.datafield[this.datafieldCount]={ name: this.fieldlist[this.datafieldCount].replace(/\s/g,'')};
 }


this.selectItem=function() {
   var  cbxObject=this;

    var item = cbxObject.jqxcombobox.jqxComboBox('getItemByValue', cbxObject.value);
               if (item!='' )
               cbxObject.jqxcombobox.jqxComboBox('selectItem', item);

}

this.selectItemByValue=function(value) {
   var  cbxObject=this;

    var item = cbxObject.jqxcombobox.jqxComboBox('getItemByValue',value);

               if (item!='' )
               cbxObject.jqxcombobox.jqxComboBox('selectItem', item);



}


this.selectFirstItem=function() {
   var  cbxObject=this;
               cbxObject.jqxcombobox.jqxComboBox('selectIndex', 0);

 }






  this.setQuery=function(newquery,pvalue=0) {
    var cbxObject=this;

    cbxObject.SQLCommand=newquery;
    cbxObject.source.data.query=newquery;

    cbxObject.value=pvalue;

    cbxObject.dataAdapter.dataBind();
  }

  this.setDisabled=function(option) {
    var cbxObject=this;
    cbxObject.jqxcombobox.jqxComboBox({ disabled: option });
  }

  this.executeQuery=function(pvalue) {
    var cbxObject=this;
    cbxObject.value=pvalue;
   cbxObject.dataAdapter.dataBind();

  }


 this.show=function() {

   var  cbxObject=this;
   this.build();
  this.source =  {

                             datatype: "json",
                             datafields:cbxObject.datafield,
                             id: cbxObject.fieldname,
                             url: 'lib/server/omnisoftComboSimpleJSON.php',
                             type:"POST",
                             root:"Rows",
                data: {
                    query : cbxObject.SQLCommand

                }

   };


this.dataAdapter = new $.jqx.dataAdapter(cbxObject.source);


/*this.dataAdapter = new $.jqx.dataAdapter(cbxObject.source,
            {
                formatData: function (data) {
                    if (cbxObject.jqxcombobox.jqxComboBox('searchString') != undefined) {
                        data.name_startsWith = cbxObject.jqxcombobox.jqxComboBox('searchString');
                        return data;
                    }
                }
            }
        );  */


   this.params=         {
                checkboxes:cbxObject.checkboxes,
                selectedIndex:0,
             //   scrollBarSize:25,
                searchMode:'startswithignorecase',
                autoComplete:true,
                //remoteAutoComplete:true,
//                 autoDropDownHeight: true,
                width: cbxObject.width,
                itemHeight:20,
                source: cbxObject.dataAdapter,
                theme: cbxObject.theme,
                displayMember: cbxObject.datafield[1].name,
                valueMember: cbxObject.datafield[0].name,
                renderer: function (index, label, value) {

                    var item = cbxObject.dataAdapter.records[index];
                    if (item != null) {
                      var label="";
		      var len = (cbxObject.datafield.length>3)? 3:cbxObject.datafield.length;
                      for(var i=1; i<len-1;i++)  {
                        label += "item."+cbxObject.datafield[i].name+ "+' '+" ;

                      }

                        label += "item."+cbxObject.datafield[i].name ;
                   //     label += "item."+cbxObject.datafield[1].name ;

                        label=eval(label);
                        //alert("valor="+value+" parametro= "+cbxObject.value);
                   //     alert(value+' '+cbxObject.value);
                     //   if (value==cbxObject.value)
                       //    cbxObject.jqxcombobox.jqxComboBox('selectIndex', index);

                     //  alert(value+' '+label);
                        return label;

                    }

                    return "";
                }
 ,

                renderSelectedItem: function(index, item)
                {
                    var selitem=cbxObject.jqxcombobox.jqxComboBox('getSelectedItem');
                    if (selitem!=undefined) {

                    var item = cbxObject.dataAdapter.records[selitem.index];
                    if (item != null) {
                      var label="";
                      var len = (cbxObject.datafield.length>3)? 3:cbxObject.datafield.length;
                      for(var i=1; i<len-1;i++)  {
                        label += "item."+cbxObject.datafield[i].name+ "+' '+" ;

                      }

                        label += "item."+cbxObject.datafield[i].name ;
                        //label = "item."+cbxObject.datafield[1].name ;

                        label=eval(label);
                        var val=eval('item.'+cbxObject.fieldname);
                        //alert(cbxObject.fieldname+"="+val);
                        document.getElementById(cbxObject.fieldname).value=val;

                        //alert(label);
                        return label;
                    }
                    }
                    return "";
                }
//                ,
//            search: function (searchString) {
  //              dataAdapter.dataBind();
    //        }

            } ;
         cbxObject.jqxcombobox.jqxComboBox(this.params);

         $(cbxObject.objName).bind('select', function (event) {
//	        var index = cbxObject.jqxcombobox.jqxComboBox('getSelectedIndex');
//                var item = cbxObject.dataAdapter.records[index];
                var item = cbxObject.jqxcombobox.jqxComboBox('getSelectedItem');

                    if (item != null) {

                       //  var val=eval('item.'+cbxObject.fieldname);
                         document.getElementById(cbxObject.fieldname).value=item.value;
			//			alert(cbxObject.fieldname+"="+item.value);

                         if (cbxObject.onchange!='' && item.value!=cbxObject.currentValue) {
                             cbxObject.currentValue=item.value;
                             setTimeout(cbxObject.onchange,0);
                         }

                    }
          });



          $(cbxObject.objName).on('bindingComplete', function (event) {

               if (cbxObject.value!='' && cbxObject.value!=0) {
               var item = cbxObject.jqxcombobox.jqxComboBox('getItemByValue', cbxObject.value);

                if (item!=undefined && item!='')  {
                  cbxObject.jqxcombobox.jqxComboBox('selectItem', item);
                  if (cbxObject.checkboxes)
                   cbxObject.jqxcombobox.jqxComboBox('checkItem', item);
                }
                 else
                  cbxObject.jqxcombobox.jqxComboBox('selectIndex', 0);
               }
               else
                  cbxObject.jqxcombobox.jqxComboBox('selectIndex', 0);



      });


 } //show


}