﻿
//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  T�TULO: omnisoftjqxComboBox.js
//  DESCRIPCI�N: Archivo que contiene la clase omnisoftjqxComboBox para la gestion de base de datos
//  FECHA DE CREACI�N: 15-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCI�N
//  1) ------------- -------------  -------------------------


omnisoftjqxComboBox=function(aObjName,afieldname,aTheme,aSQLCommand,sWidth,aValue,aAll,aOnChange) {
 this.objName='#'+aObjName;
 this.jqxcombobox=$(this.objName);
 this.theme=aTheme;
 this.SQLCommand=aSQLCommand;
 this.fieldname=afieldname;
 this.width=sWidth;
 this.seleccion=(aAll==undefined)?'':aAll;
 this.onchange=(aOnChange==undefined)?'':aOnChange;
 this.value=(aValue==undefined)?'':aValue;
   this.source=new Array();
   this.source.sql='sql';
   this.dataAdapter;
   this.maxrows=100;
   this.datafield=new Array();
   this.datafieldCount=0;
   this.params;
   this.inicial=1;
   this.searching=false;

 this.build=function() {
     var slist=this.SQLCommand.split('from')[0];
     var scolumnlist=slist.substring(7,slist.length);
     var columnlist=scolumnlist.split(',');

	 var columnName='';
     for (this.datafieldCount=0;this.datafieldCount<columnlist.length;this.datafieldCount++) {
	     columnName=columnlist[this.datafieldCount].split(' as ');

	     if (columnName.length>1) {


this.datafield[this.datafieldCount]={ name: String.trim(columnName[1])};
		 }
else
     this.datafield[this.datafieldCount]={ name: String.trim(columnlist[this.datafieldCount])};
	 }
 }

this.selectItem=function() {
   var  cbxObject=this;
   var item;
   var nitems=cbxObject.dataAdapter.records.length;
   if (document.getElementById(cbxObject.fieldname).readOnly==true)
    cbxObject.jqxcombobox.jqxComboBox({ disabled: true  });
    else
    cbxObject.jqxcombobox.jqxComboBox({ disabled: false });
   for (var i=0; i<nitems;i++) {
        item = cbxObject.dataAdapter.records[i];

       if (item != null) {
           var val=eval('item.'+cbxObject.fieldname);
		   alert("selectitem="+cbxObject.fieldname + " " + val + " " + document.getElementById(cbxObject.fieldname).value);
           if (val==document.getElementById(cbxObject.fieldname).value) {
                cbxObject.jqxcombobox.jqxComboBox('selectedIndex',i);
                return;

           }
       }
   }

 }

  this.setDisabled=function(option) {
    var cbxObject=this;
    cbxObject.jqxcombobox.jqxComboBox({ disabled: option });
  }

  this.executeQuery=function(pvalue) {
    var cbxObject=this;
    cbxObject.value=pvalue;
    cbxObject.searching=false;
 //   alert(cbxObject.dataAdapter.source.data);
   cbxObject.dataAdapter.dataBind();

//   alert('entro');
 //  cbxObject.jqxcombobox.jqxComboBox('selectIndex', value);

  }


 this.show=function() {
   var  cbxObject=this;

   this.build();
  this.source =  {

                             datatype: "json",
                             datafields:cbxObject.datafield,
                             id: cbxObject.fieldname,
                             url: "lib/server/omnisoftComboJSON.php",
                             type:"POST",
                             root:"entry",
                             record:"content",
                             processdata: function (data) {
                             data.query = cbxObject.SQLCommand;
                             } ,
                data: {
                    featureClass: "P",
                    style: "full",
                    maxRows: 15
                }

   };


this.dataAdapter = new $.jqx.dataAdapter(cbxObject.source,
{
                    formatData: function (data) {
                       // data.name_startsWith  ="COMERCIAL";
                        data.name_startsWith = cbxObject.jqxcombobox.jqxComboBox('searchString');
                        return data;
                    },


    loadServerData: function (serverdata, source, callback) {
        $.ajax({
            dataType: source.datatype,
                             url: "lib/server/omnisoftComboJSON.php",
                             type:"POST",
            data: serverdata,
            success: function (data, status, xhr) {

                var dataArray = new Array();
                var value='';
                for (var i = 0; i < data.length; i++) {
                    var record = data[i];
                    var datarow = {};
                    for (var j = 0; j < source.datafields.length; j++) {
                        var datafield = source.datafields[j];
                        if (undefined == datafield || datafield == null) {
                            continue;
                        }
                        value='record.'+datafield.name;
                       // alert(datafield.name);
                        value=eval(datafield.name+'='+value);
                        datarow[datafield.name] = value;
                    }
                    dataArray[i] = datarow;
//                    alert(i+'='+dataArray[i].nombre_per+' ,' +dataArray[i].apellido_per);
                }
                // send the loaded records to the jqxDataAdapter plug-in.
                callback({ records: dataArray });
            }
        });
    }
}
);



   this.params=         {
                width: cbxObject.width,
                height: 15,
                autoDropDownHeight: true,
                remoteAutoComplete: true,
                source: cbxObject.dataAdapter,
               // searchmode:'startsWidth',
                theme: cbxObject.theme,
                selectedIndex: 0,
                displayMember: cbxObject.datafield[1].name,
                valueMember: cbxObject.datafield[0].name,
                renderer: function (index, label, value) {
                    var item = cbxObject.dataAdapter.records[index];
//                    alert(item.apellido_per+' '+item.serial_per);
                    if (item != null) {
                      var label="";
                      for(var i=1; i<cbxObject.datafield.length-1;i++)  {
                        label += "item."+cbxObject.datafield[i].name+ "+','+" ;

                      }
                        label += "item."+cbxObject.datafield[i].name ;
                        label=eval(label);
                        return label;

                    }
                    return "";
                },

                renderSelectedItem: function(index, item)
                {

                    var item = cbxObject.dataAdapter.records[index];
					//alert('seleccion='+item+index);
                    if (item != null) {
                      var label="";
                      for(var i=1; i<cbxObject.datafield.length-1;i++)  {
                        label += "item."+cbxObject.datafield[i].name+ "+','+" ;
                      }
                        label += "item."+cbxObject.datafield[i].name ;
                        label=eval(label);
                        var val=eval('item.'+cbxObject.fieldname);
   //                     alert(cbxObject.fieldname+"="+val);
                        document.getElementById(cbxObject.fieldname).value=val;
                        return label;
                    }
                    return "";
                },
                search: function (searchString) {
                   //alert(searchString);
                    cbxObject.dataAdapter.dataBind();
                },
            } ;
          cbxObject.jqxcombobox.jqxComboBox(cbxObject.params);

         cbxObject.jqxcombobox.bind('change', function (event) {

                var index = cbxObject.jqxcombobox.jqxComboBox('getSelectedIndex');
                var item = cbxObject.dataAdapter.records[index];
                     //alert("entro a cambiar"+item);
                    if (item != null) {
                         var val=eval('item.'+cbxObject.fieldname);

                         document.getElementById(cbxObject.fieldname).value=val;
						//alert(cbxObject.fieldname+"="+val);

                         if (cbxObject.onchange!='')
                             setTimeout(cbxObject.onchange,0);

                    }
          });
          cbxObject.jqxcombobox.on('bindingComplete', function (event) {
           // alert(cbxObject.value);
             if (cbxObject.searching==false) {
               var item = cbxObject.jqxcombobox.jqxComboBox('getItemByValue', cbxObject.value);
               cbxObject.jqxcombobox.jqxComboBox('selectItem', item);
             }
             cbxObject.searching=true;  
      });


 } //show


}