<?php
//error_reporting(E_ALL);
//ini_set('display_errors', TRUE);
//ini_set('display_startup_errors', TRUE);
//date_default_timezone_set('America/Guayaquil');

require_once "phpExcel/Classes/PHPExcel/IOFactory.php";
require_once "phpExcel/Classes/PHPExcel.php";
include('../adodb/adodb.inc.php');
include('../adodb/adodb-errorhandler.inc.php');

include('../../config/config.inc.php');
include('../server/omnisoftAcademicoFunciones.php');

function cellsToMergeByColsRow($start = -1, $end = -1, $row = -1){
    $merge = 'A1:A1';
    if($start>=0 && $end>=0 && $row>=0){
        $start = PHPExcel_Cell::stringFromColumnIndex($start);
        $end = PHPExcel_Cell::stringFromColumnIndex($end);
        $merge = "$start{$row}:$end{$row}";
    }
    return $merge;
}


function omnisoftConnectDB() {
global $DBConnection;

try {
$dblink = NewADOConnection($DBConnection);
return $dblink;
}
catch(exception $e) {
 var_dump($e);

 adodb_backtrace($e->gettrace());
 return 0;
}
 return 0;
}

function buscarMateriaAlumno($dblink,$id_alumno,$serial_matpro){
   $SQLCmdEstudiante="select id_alumno,alumno.serial_alu,paralelo_alumno.serial_paralu,materia_alumno.serial_matalu ";
   $SQLCmdEstudiante.=" from periodo,alumno,paralelo_alumno,materia_profesor,materia_alumno,nota where  paralelo_alumno.serial_per=periodo.serial_per and paralelo_alumno.serial_alu=alumno.serial_alu and paralelo_alumno.serial_par=materia_profesor.serial_par and periodo.activo_per='SI'   and materia_profesor.serial_matpro=materia_alumno.serial_matpro and nota.serial_matalu=materia_alumno.serial_matalu and alumno.serial_alu=materia_alumno.serial_alu and materia_alumno.serial_matpro=".$serial_matpro."  and alumno.id_alumno='".$id_alumno."'";
//   echo $SQLCmdEstudiante;

   $rsEstudiante=$dblink->Execute($SQLCmdEstudiante);
   $resultado=(!$rsEstudiante  || $rsEstudiante->RecordCount()<=0)?0:$rsEstudiante->fields['serial_matalu'];
   return $resultado;

}

function cargarNotasEstudiante($dblink,$objPHPExcel,$serial_matpro,$rsParciales,&$mensaje) {

 $row=9;
 $salir=false;
 while (!$salir) {
     $id_alumno=$objPHPExcel->getActiveSheet()->getCellByColumnAndRow(0, $row)->getValue();
    // echo $id_alumno;
     if ($id_alumno!='') {
     $serial_matalu=buscarMateriaAlumno($dblink,$id_alumno,$serial_matpro);
     if ($serial_matalu!=0) {

     $rsParciales->MoveFirst();
     while (!$rsParciales->EOF) {

       $col=$rsParciales->fields['orden_prc']+1;
       $snota=$objPHPExcel->getActiveSheet()->getCellByColumnAndRow($col, $row)->getValue();
//       echo "antes=". $snota."---";

       $snota = str_replace(",", ".", $snota);
  //     echo "despues".$snota."---";

// Produce: Hll Wrld f PHP

   //    $nota=round($objPHPExcel->getActiveSheet()->getCellByColumnAndRow($col, $row)->getValue(),2);
       $nota=round($snota,2);

       if ($nota>10) {
          $mensaje="Error: No puede registrar notas mayores a 10, por favor revise el estudiante cuyo codigo es  ".$id_alumno;
          $salir=true;

       }
       else
 //      echo "nota=".$nota;
       if (is_numeric($nota))   {
          $nombrecampo="nota".$rsParciales->fields['orden_prc'];
          if ($nota>10)
              $nota=0;
          $SQLCmd="update nota set ".$nombrecampo."=".$nota." where serial_matalu=".$serial_matalu;
        //  echo $SQLCmd;
          $dblink->Execute($SQLCmd);
       }
     //  else echo "no numerico".$nota;
       $rsParciales->MoveNext();
    }
    }
    else {
          $mensaje="Error: No existe el estudiante con codigo ".$id_alumno;
          $salir=true;
    }
  }
  else $salir=true;
      $row++;

 }
 return 0;
}


function procesarCargaNotas($archivo,&$mensaje) {
   $serial_matpro=$_POST['serial_matpro'];
   $serial_tri=$_POST['serial_tri'];
   $serial_par=$_POST['serial_par'];
   $serial_pro=$_POST['serial_pro'];

   $dblink=omnisoftConnectDB();

   try {
   $SQLCmd="select nombre_per,nombre_niv,nombre_par, periodo.serial_per from periodo,nivel,paralelo where periodo.serial_per=paralelo.serial_per and nivel.serial_niv=paralelo.serial_niv and paralelo.serial_par=".$serial_par;
   $rsPeriodo=$dblink->Execute($SQLCmd);
   }
   catch (exception $e) {
          var_dump($e);

          adodb_backtrace($e->gettrace());
          $mensaje="Error: No se pudo encontrar el periodo lectivo activo";
	  return 1;
   }


      $dblink->Execute("SET NAMES utf8");

   $objPHPExcel = PHPExcel_IOFactory::load($archivo);
   $objPHPExcel->setActiveSheetIndex();

   //titulo

   $nombre_niv=$objPHPExcel->getActiveSheet()->getCellByColumnAndRow(1, 1)->getValue();
   $nombre_par=$objPHPExcel->getActiveSheet()->getCellByColumnAndRow(1, 2)->getValue();
   $documentoidentidad_epl=$objPHPExcel->getActiveSheet()->getCellByColumnAndRow(1, 3)->getValue();
   $nombre_mat=$objPHPExcel->getActiveSheet()->getCellByColumnAndRow(1, 5)->getValue();

  // echo "nivel=".$nombre_niv.", paralelo=".$nombre_par.", cedula=". $documentoidentidad_epl.", nombre_mat=".$nombre_mat;

   if ($nombre_niv!=$rsPeriodo->fields['nombre_niv']) {
      $mensaje="Advertencia: El nombre del grado o curso que se encuentra registrado en el archivo excel ".$archivo." no coincide con el grado o curso seleccionado para la carga";

      $rsPeriodo->Close();
      $dblink->Close();
      return 1;
    }

    if ($nombre_par!=$rsPeriodo->fields['nombre_par']) {
      $mensaje="Advertencia: El paralelo que se encuentra registrado en el archivo excel ".$archivo." no coincide con el paralelo seleccionado para la carga";
      $rsPeriodo->Close();
      $dblink->Close();

      return 1;
   }

   try {
   $SQLCmd="select nombre_mat,materia.serial_mat from materia,materia_nivel,materia_profesor where materia.serial_mat=materia_nivel.serial_mat and materia_nivel.serial_matniv=materia_profesor.serial_matniv and materia_profesor.serial_matpro=".$serial_matpro;
   $rsMateria=$dblink->Execute($SQLCmd);
   }
   catch (exception $e) {
  //        var_dump($e);

          adodb_backtrace($e->gettrace());
          $mensaje="Error: no se puede encontrar la materia especificada en la plantilla excel";
          return 1;
   }

   if ($nombre_mat!=$rsMateria->fields['nombre_mat']) {
      $mensaje="Advertencia: La materia que se encuentra registrada en el archivo excel ".$archivo." no coincide con la materia seleccionada para la carga";

      $rsPeriodo->Close();
      $rsMateria->Close();
      $dblink->Close();
      return 1;
    }

   try {
   $SQLCmd="select documentoidentidad_epl, concat(apellido_epl,' ',nombre_epl) as nombre_docente from profesor,empleado where profesor.serial_epl=empleado.serial_epl and serial_pro=".$serial_pro;
   $rsDocente=$dblink->Execute($SQLCmd);
   }
   catch (exception $e) {
//          var_dump($e);
          $mensaje="Error: no se puede encontrar la materia especificada en la plantilla excel";

          adodb_backtrace($e->gettrace());
          return 1;

   }

   if ($documentoidentidad_epl!=$rsDocente->fields['documentoidentidad_epl']) {
      $mensaje="Advertencia: La cedula o pasaporte que se encuentra registrado en el archivo excel ".$archivo." no coincide con su cedula o pasaporte ";

      $rsPeriodo->Close();
      $rsMateria->Close();
      $rsDocente->Close();
      $dblink->Close();
      return 1;
    }



   try {
   $SQLCmd="select abreviatura_prc,orden_prc,nombre_prc,tipo_prc,fecini_prc,fecfin_prc,current_date as fechoy_prc,nombre_tri from nivel,paralelo,trimestre,parcial where trimestre.serial_per=paralelo.serial_per and nivel.serial_sec=trimestre.serial_sec and paralelo.serial_niv=nivel.serial_niv and paralelo.serial_par=".$serial_par." and trimestre.serial_tri=parcial.serial_tri and activo_prc='SI' and desplegable_prc='SI'  and CURRENT_DATE between fecini_prc and fecfin_prc order by orden_prc";
//   echo $SQLCmd;
   $rsParciales=$dblink->Execute($SQLCmd);

   if (!$rsParciales || $rsParciales->RecordCount()<=0) {
      $mensaje="Advertencia: No existen parciales activos para cargar notas, por favor consulte en secretaria ";

      $rsPeriodo->Close();
      $rsMateria->Close();
      $rsDocente->Close();
      $rsParciales->Close();
      $dblink->Close();
      return 1;


   }

   $result=cargarNotasEstudiante($dblink,$objPHPExcel,$serial_matpro,$rsParciales,$mensaje);
   calcularPromedios($dblink,$serial_matpro,$serial_tri,  $serial_par,  $serial_pro);

   }
   catch (exception $e) {
//          var_dump($e);
          $mensaje="Error: no se pueden cargar las notas revise por favor la plantilla excel";

          adodb_backtrace($e->gettrace());

	  return 1;
   }



   $rsDocente->Close();
   $rsPeriodo->Close();
   $rsParciales->Close();
   $rsMateria->Close();
   $dblink->Close();
   return $result;

}

if(!empty($_FILES)) {
$data['result']=0;
$data['message']="";
$result=true;

$local_dir=getcwd();
$local_dir=explode("/",$local_dir);
$target_dir=construirDirectorio($local_dir);
$target_dir .=  "archivos/notas/".$_POST['serial_matpro']."/";
//echo $target_dir;
//$target_dir =  $_SERVER["DOCUMENT_ROOT"]."/academium-portal-nuevo/archivos/notas/".$_POST['serial_matpro']."/";

//echo  $target_dir;
if (!file_exists($target_dir)) {
   $result= mkdir($target_dir, 0777, true);
   if ($result==false) {
      $data['result']=1;
      $data['message']="No se pudo crear la carpeta del docente, por favor contactarse con el administrador del sistema";
   }
}

if ($result) {
$target_file = $target_dir . basename($_FILES["uploadFile"]["name"]);
//echo $target_file;
/*if (file_exists($target_file)) {
     $data['result']=1;
     $data['message']="El archivo ".basename($_FILES["uploadFile"]["name"])." ya existe, por favor seleccione otro archivo para cargar";
}
else { */
if(is_uploaded_file($_FILES['uploadFile']['tmp_name'])) {
if(move_uploaded_file($_FILES['uploadFile']['tmp_name'],$target_file)) {
     $data['result']=procesarCargaNotas($target_file,$mensaje);
     //echo "result=".$data['result'];
     $data['message']=$mensaje;  //"El archivo ".basename($_FILES["uploadFile"]["name"])." fue cargado exitosamente";


}
else  {
     $data['result']=1;
     $data['message']="El archivo ".basename($_FILES["uploadFile"]["name"])." no pudo ser cargado, por favor intente con otro archivo";

}
}
else {
     $data['result']=1;
     $data['message']="El archivo ".basename($_FILES["uploadFile"]["name"])." no pudo ser cargado, por favor contactese con el administrador del sistema";

}
}
//}
}
header("Content-type: application/json");
//echo "{\"data\":" .json_encode($data). "}";

echo json_encode($data);


?>

