<?php

  require_once ('phpexcel/Classes/PHPExcel.php');
  require_once('../adodb/adodb.inc.php');
  require('../../config/config.inc.php');

  $monthDay=array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
  $weekDay=array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");


//------------------------------------------------------------------------------------------------------------------------
//  NOMBRE: OmnisoftExcel
//  DESCRIPCIN: Clase General para crear una hoja Excel
//------------------------------------------------------------------------------------------------------------------------

   class OmnisoftExcelDocumento {

               var $SQLCommandArray;        // Array CHAR, comando sql a ejecutar
               var $resultSetArray;           // Array OBJECT, resultados de la consulta
               var $dblink;             // OBJECT, enlace base datos
               var $record;             // OBJECT, registro actual
               var $activeColumnArray; // OBJECT, arreglo de todas las columnas
               var $objPHPExcel;
               var $objWorksheet;
               var $filename;
               var $numrows;
               var $numcols;
               var $nSQL;

                //  NOMBRE:  OmnisoftRTF
                //  DESCRIIPCIN:  Crea un reporte RTF
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Alogo              char        25            nombre del grid
                //  2)       Atitle              char        25            nombre de la pagina que invoca al grid
                //  3)       Aform              char        25            nombre del formulario de ingreso y edicion de datos
                //  5)       Atable             char        100           tabla a afectar
                //  6)       ASQLCommand        char        100           comando sql para la seleccion de datos
                //  7)       Aheight            int        25             alto del grid
                //  8)       Awidth             int        25             ancho del grid
                //  9)       Afont              char        25            fuente de las letras
                //  10)       AbackgroundColor   char        25            color del fondo del grid
                //  VALOR RETORNO:   objeto de la clase OmnisoftGrid

                function __construct($afilename,$aSQLCommand,$aSQLDirection)
                {

		 $this->filename=$afilename;
                 $this->SQLCommandArray=$aSQLCommand;
                 $this->SQLDirectionArray=$aSQLDirection;

                 $this->connectDB();

              //   $this->dblink->SetFetchMode(ADODB_FETCH_NUM);

                 $this->objPHPExcel = new PHPExcel();
                 $objReader = PHPExcel_IOFactory::createReader('Excel5');
                 $this->objPHPExcel = $objReader->load($this->filename);

                 $this->objWorksheet = $this->objPHPExcel->getActiveSheet();

                 $this->numrows = $this->objWorksheet->getHighestRow();
                 $cols = $this->objWorksheet->getHighestColumn();
		   $this->nSQL=count($this->SQLCommandArray);

                 $this->numcols = PHPExcel_Cell::columnIndexFromString($cols);
                 $this->resultSetArray=Array();


                }



                //  NOMBRE:  connectDB
                //  DESCRIIPCIN:  despliega el Grid
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Attributes         char        100            atributos de la fila seleccionada
                //  VALOR RETORNO:   ninguno

                function connectDB()
                {

                  global $DBConnection;

                 $this->dblink = NewADOConnection($DBConnection);

                 if (!$this->dblink)
                     die("Error Fatal: NO SE PUEDE CONECTAR A LA BASE DE DATOS");
                  $this->dblink->Execute("SET NAMES utf8");


                }

                 function crearResultSet() {

                   for ($i=0; $i<$this->nSQL; $i++)  {
                       $this->resultSetArray[$i]=$this->dblink->Execute($this->SQLCommandArray[$i]);
                   }

                 }
                 function replaceKey($n) {
                       $SQLCmd=$this->SQLCommandArray[$n];
                       for ($j=0; $j < $n; $j++)
                           if (isset($this->resultSetArray[$j]->fields['SERIAL'])) {
                           $masterkey=$this->resultSetArray[$j]->fields['SERIAL'];
			   $k=$j+1;
			   $smasterkey='_masterkey'.$k.'_';

                     //      echo $smasterkey."=".$masterkey."<br>";
			   $SQLCmd=str_replace($smasterkey,$masterkey,$SQLCmd);
                          }
                   return $SQLCmd;
                 }

                 function replaceParameter(&$SQLCmd,$params,$row,$col) {
                       $n=count($params);

                       for ($j=1; $j < $n; $j++)  {
			   $k=$j+1;
			   $sparam='_param'.$k.'_';
			   $aparam=explode($params[$j]);

			   $aparam=$params[$j]{0};

                       $value=$this->objWorksheet->getCell($params[$j])->getValue();
    		       $SQLCmd=str_replace($sparam,$value,$SQLCmd);
                       }
                   return $SQLCmd;
                 }


                 function copyRow($dest,$source) {
                   $starting_pos = ord('A');

                   for ($i=0; $i<$this->numcols; $i++)  {

                      $valor=$this->objWorksheet->getCellByColumnAndRow($i, $source)->getValue();
                      $this->objWorksheet->setCellValueByColumnAndRow($i, $dest,$valor );
                      $pos=chr($starting_pos+$i).$dest;
                      $this->objWorksheet->duplicateStyle($this->objWorksheet->getStyleByColumnAndRow($i,$source) ,$pos);

                   }

                 }

                 function recorrerDatosVertical($fieldname,$row,$col,$index,$lastindex,&$SQLCmdAux="") {
        //           echo $this->resultSetArray[1]->fields[0]." ".$index." ".$lastindex. " ".$SQLCmdAux."<br>";

                   if ($index>$lastindex || ($index<$lastindex && ($this->resultSetArray[$index]->EOF ))) //|| $this->resultSetArray[$index]->RecordCount()<=1)))
                       return;

                  if ($index==$lastindex) {
                      $SQLCmd=$this->replaceKey($index);
          //            echo "origen=".$SQLCmd." <br> nuevo= ".$SQLCmdAux."<br>";
                      if ($SQLCmdAux!=$SQLCmd) {
                          $SQLCmdAux=$SQLCmd;
                                   //    echo $SQLCmd."<br>";
                          $this->resultSetArray[$index]=$this->dblink->Execute($SQLCmd);
                             $nrow=$row;
                             if ($this->resultSetArray[$index] )
                                while (!$this->resultSetArray[$index]->EOF) {
                            $this->objWorksheet->setCellValueByColumnAndRow($col, $nrow,$this->resultSetArray[$index]->fields[$fieldname] );
                         //   echo $nrow."  ".$this->resultSetArray[$index]->fields[$fieldname]."<br>";
			    $nrow++;
                            $this->resultSetArray[$index]->MoveNext();

                               } //while

                                }//SQLCmdAux
                   }

                    else   {
                     $this->resultSetArray[$index]->MoveFirst();

                    $indexaux=$index+1;
                   if ( $this->SQLDirectionArray[$index]=="HORIZONTAL" )  {
                     $ncol=$col;
                    $this->resultSetArray[$index]->MoveFirst();
                    while (!$this->resultSetArray[$index]->EOF) {
                       if ($this->resultSetArray[$indexaux])
                       $this->resultSetArray[$indexaux]->MoveFirst();

                        $this->recorrerDatosVertical($fieldname,$row,$ncol,$indexaux,$lastindex,$SQLCmdAux);
                       // echo $SQLCmdAux."<br>";
                     //  echo   $this->resultSetArray[$index]->fields[0]."<br>";
                   $this->resultSetArray[$index]->MoveNext();
                       $ncol++;

                   }
                   }
                    else   {
                    $nrow=$row;
                    $this->resultSetArray[$index]->MoveFirst();
                    while (!$this->resultSetArray[$index]->EOF) {

                    if ($this->resultSetArray[$indexaux])
                    $this->resultSetArray[$indexaux]->MoveFirst();

                   $this->recorrerDatosVertical($fieldname,$nrow,$col,$indexaux,$lastindex,$SQLCmdAux);
                   $this->resultSetArray[$index]->MoveNext();
                       $nrow++;

                   }

                    }
                    }
                 }

                 function procesarValorVR($fieldname,$row,$col) {
                   $found=false;
		   $nrow=$row;
                   for ($i=0; $i<$this->nSQL && $found==false; $i++)  {

		   if ($i>0) {
		       $SQLCmd=$this->replaceKey($i);
                       $this->resultSetArray[$i]=$this->dblink->Execute($SQLCmd);
                          }

                      if ($this->resultSetArray[$i]) {

                          if ($i>0)
                          $this->resultSetArray[$i]->MoveFirst();

                         if (isset($this->resultSetArray[$i]->fields[$fieldname])) {
                            $found=true;

                           $j= $i-1;
                        if ($j >0  && $this->resultSetArray[$j]->RecordCount()>1) {
                            $this->recorrerDatosVertical($fieldname,$row,$col,1,$i);


                        } // if $i-1>0
                        else if ($j==0)
                        while (!$this->resultSetArray[$i]->EOF) {

                            $this->objWorksheet->setCellValueByColumnAndRow($col, $nrow,$this->resultSetArray[$i]->fields[$fieldname] );
			    $nrow++;
                            $this->resultSetArray[$i]->MoveNext();

                          } //while
                         else
                            $this->objWorksheet->setCellValueByColumnAndRow($col, $nrow,$this->resultSetArray[$i]->fields[$fieldname] );



                          }  //if isset
		      }  // if resultset
                   }  //for
                 }


                 function procesarValorHR($fieldname,$row,$col) {
                   $found=false;
		   $ncol=$col;
                   $starting_pos = ord('A');

                   for ($i=0; $i<$this->nSQL && $found==false; $i++)  {

		   if ($i>0) {
		       $SQLCmd=$this->replaceKey($i);
                       //echo $SQLCmd;
                       $this->resultSetArray[$i]=$this->dblink->Execute($SQLCmd);
                          }


                      if ($this->resultSetArray[$i]) {
                          $this->resultSetArray[$i]->MoveFirst();

                         if (isset($this->resultSetArray[$i]->fields[$fieldname])) {
                            $found=true;


                        while (!$this->resultSetArray[$i]->EOF) {

                            $this->objWorksheet->setCellValueByColumnAndRow($ncol, $row,$this->resultSetArray[$i]->fields[$fieldname] );
                            if ($ncol!=$col) {
                            $pos=chr($starting_pos+$ncol).$row;
                            $this->objWorksheet->duplicateStyle($this->objWorksheet->getStyleByColumnAndRow($ncol-1,$row) ,$pos);
			    }
			    $ncol++;
                            $this->resultSetArray[$i]->MoveNext();

                          } //while


                          } //if  isset
		      }  // if resultarray

                   } //for
                 }


                 function procesarValorHC($fieldname,$row,$col) {
                   $found=false;
		   $ncol=$col;
                   $starting_pos = ord('A');

                   for ($i=0; $i<$this->nSQL && $found==false; $i++)  {

		   if ($i>0) {
		       $SQLCmd=$this->replaceKey($i);

                       $this->resultSetArray[$i]=$this->dblink->Execute($SQLCmd);

                          }

                      if ($this->resultSetArray[$i]) {
                          $this->resultSetArray[$i]->MoveFirst();

                         if (isset($this->resultSetArray[$i]->fields[$fieldname])) {
                            $found=true;

                        while (!$this->resultSetArray[$i]->EOF) {

                               if ($ncol!=$col)
                               $this->objWorksheet->insertNewColumnBeforeByIndex($ncol,1);

                               $this->objWorksheet->setCellValueByColumnAndRow($ncol, $row,$this->resultSetArray[$i]->fields[$fieldname] );
			       if ($ncol!=$col) {

                               $pos=chr($starting_pos+$ncol).$row;

                               $this->objWorksheet->duplicateStyle($this->objWorksheet->getStyleByColumnAndRow($ncol-1,$row) ,$pos);

                               }
     			       $ncol++;
                               $this->resultSetArray[$i]->MoveNext();


                          }
                          }
		      }

                   }
                 }

                 function procesarValorVC($fieldname,$row,$col,&$rowadded) {
                   $found=false;
		   $nrow=$row;
                   $starting_pos = ord('A');

                   for ($i=0; $i<$this->nSQL && $found==false; $i++)  {

		   if ($i>0) {
		       $SQLCmd=$this->replaceKey($i);
		       //echo $SQLCmd;

                       $this->resultSetArray[$i]=$this->dblink->Execute($SQLCmd);
                          }

                      if ($this->resultSetArray[$i]) {
                          $this->resultSetArray[$i]->MoveFirst();

                         if (isset($this->resultSetArray[$i]->fields[$fieldname])) {
                            $found=true;

                        while (!$this->resultSetArray[$i]->EOF) {

                               if ($rowadded==false && $row!=$nrow )  {
                               $this->objWorksheet->insertNewRowBefore($nrow, 1);
                               $this->copyRow($nrow,$nrow+1);
                                $rowadded=true;
			       }

                               $this->objWorksheet->setCellValueByColumnAndRow($col, $nrow,$this->resultSetArray[$i]->fields[$fieldname] );
			       if ($row!=$nrow) {
                               $pos=chr($starting_pos+$col).$nrow;
                               $this->objWorksheet->duplicateStyle($this->objWorksheet->getStyleByColumnAndRow($col,$nrow-1) ,$pos);
                               }
     			       $nrow++;
                               $this->resultSetArray[$i]->MoveNext();

                          }
                          }
		      }

                   }
                 }

		 function procesarLeerValor($fieldname,$row,$col) {
                   $found=false;
		   $nrow=$row;
                   $params=explode(',',$fieldname);
                   $fieldname=$params[0];

                   for ($i=0; $i<$this->nSQL && $found==false; $i++)  {

		   if ($i>0) {
		       $SQLCmd=$this->replaceKey($i);
                       $this->replaceParameter($SQLCmd,$params,$nrow,$col);

                       $this->resultSetArray[$i]=$this->dblink->Execute($SQLCmd);
                          }

                      if ($this->resultSetArray[$i]) {
                          $this->resultSetArray[$i]->MoveFirst();

                         if (isset($this->resultSetArray[$i]->fields[$fieldname])) {
                            $found=true;


                        while (!$this->resultSetArray[$i]->EOF) {
                            $this->objWorksheet->setCellValueByColumnAndRow($col, $nrow,$this->resultSetArray[$i]->fields[$fieldname] );
			    $nrow++;
                            $this->resultSetArray[$i]->MoveNext();
                          }
                          }
		      }
                   }


                 }

                 function showIt() {


                 $this->resultSetArray[0]=$this->dblink->Execute($this->SQLCommandArray[0]);

                      $template = $this->objPHPExcel->getActiveSheet();
                       $template->setTitle('Hoja 0');
                       $sheetIndex = 1;

                 while (!$this->resultSetArray[0]->EOF) {
                       $templateB = clone $template;
                       $templateB->setTitle('Hoja '.$sheetIndex);
                       $this->objPHPExcel->addSheet($templateB,$sheetIndex);
                       $sheetIndex++;
                   $this->resultSetArray[0]->MoveNext();
                 }

                   $this->resultSetArray[0]->MoveFirst();

                   $sheetIndexAux=0;
                 while (!$this->resultSetArray[0]->EOF && $sheetIndexAux<$sheetIndex) {
                   $this->objWorksheet = $this->objPHPExcel->setActiveSheetIndex($sheetIndexAux);
                   $sheetIndexAux++;

                 for ($row = 1; $row <= $this->numrows; ++$row) {
		     $rowadded=false;
                   for ($col = 0; $col <= $this->numcols; ++$col) {

                      $valor=$this->objWorksheet->getCellByColumnAndRow($col, $row)->getValue();
                      $svalor=substr($valor,0,13);

                      if (strncmp($svalor,"%%DETHC_",8)==0 ) {

                         $len=strlen($valor)-10;
                         $fieldname=substr($valor,8,$len);
                         $this->procesarValorHC($fieldname,$row,$col);

                      }
                      else
                      if (strncmp($svalor,"%%DETHR_",8)==0 ) {

                         $len=strlen($valor)-10;
                         $fieldname=substr($valor,8,$len);
                         $this->procesarValorHR($fieldname,$row,$col);

                      }
                      else

                      if (strncmp($svalor,"%%DETVR_",8)==0 ) {

                         $len=strlen($valor)-10;
                         $fieldname=substr($valor,8,$len);
                         $this->procesarValorVR($fieldname,$row,$col);

                      }
                      else
                      if (strncmp($svalor,"%%DETVC_",8)==0 ) {

                         $len=strlen($valor)-10;
                         $fieldname=substr($valor,8,$len);
                         $this->procesarValorVC($fieldname,$row,$col,$rowadded);


                      }
                      else
                      if (strncmp($svalor,"%%LEER_VALOR(",13)==0 ) {

                         $len=strlen($valor)-16;
                         $fieldname=substr($valor,13,$len);
                         $this->procesarLeerValor($fieldname,$row,$col);

                      }

                      else {

                          $svalor=substr($valor,0,2);
                          if (strncmp($svalor,"%%",2)==0 ) {
                         $len=strlen($valor)-4;
                         $fieldname=substr($valor,2,$len);
                         $this->procesarValorVR($fieldname,$row,$col);

			  }

                      }




                    }

                 }
                                     $this->resultSetArray[0]->MoveNext();

                 }
                  header('Content-Type: application/vnd.ms-excel');
                  header('Content-Disposition: attachment;filename="documento.xls"');
                  header('Cache-Control: max-age=0');


                  $objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'Excel5');
                  $objWriter->save('php://output');

		 }


}


?>