<?php
//------------------------------------------------------------------------------------------------------------------------
//  PROYECTO: Librerias para manejo de Reportes en PDF
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//------------------------------------------------------------------------------------------------------------------------
//  TTULO: OmnisoftGrid.php
//  DESCRIPCIN: Archivo que contiene la clase de creacin de PDFs
//  FECHA DE CREACIN: 07-Agosto-2005
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCIN
//  1) ------------- -------------  -------------------------

//define('FPDF_FONTPATH','C:\\Archivos de programa\\Apache Group\\Apache\\htdocs\\OmnisoftGrid\\lib\\fpdf\\font');

  require('fpdf/fpdf.php');
  require('../../config/config.inc.php');





//------------------------------------------------------------------------------------------------------------------------
//  CONSTANTES
//  CONSTANTES PARA EL MANEJO DE EVENTOS
//------------------------------------------------------------------------------------------------------------------------

define(OMNISOFT_VERTICAL,'P');
define(OMNISOFT_HORIZONTAL,'L');

define(OMNISOFT_VERTICAL_WIDTH,210);
define(OMNISOFT_HORIZONTAL_WIDTH,297);


/*define(OMNISOFT_DELETE_EVENT,3);
define(OMNISOFT_SAVE_EVENT,4);
define(OMNISOFT_SEARCH_EVENT,5);
define(OMNISOFT_LOAD_EVENT,6);
*/
$monthDay=array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
$weekDay=array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");


//------------------------------------------------------------------------------------------------------------------------
//  NOMBRE: OmnisoftPDF
//  DESCRIPCIN: Clase General para crear un report PDF
//------------------------------------------------------------------------------------------------------------------------

         class OmnisoftPDFIndividual extends FPDF {
               var $slogo;              // CHAR nombre del logo
               var $stitle;               // CHAR titulo
               var $stitleFontSize;        // INTtamao de la fuente del titulo
               var $sHeader;         // CHAR cabecera
               var $sFooter;           // CHAR pie de pagina
               var $sfont;              // CHAR tipo de letra
               var $sbackgroundColor;   // INT,color del fondo
               var $sfontColor;   //  INT,color de la letra
               var $spageSize;                // INT, tamao de la pagina
               var $spageOrientation;                // INT, tamao de la pagina
               var $columnCount;                  // INT, numero de columnas
               var $activeColumnArray; // OBJECT, arreglo de todas las columnas
               var $columnDetailCount;                  // INT, numero de columnas
               var $activeColumnDetailArray; // OBJECT, arreglo de todas las columnas
               var $rsEmpresa; // OBJECT, arreglo de todas las columnas

                //  NOMBRE:  OmnisoftPDF
                //  DESCRIIPCIN:  Crea un reporte PDF
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Alogo              char        25            nombre del grid
                //  2)       Atitle              char        25            nombre de la pagina que invoca al grid
                //  3)       Aform              char        25            nombre del formulario de ingreso y edicion de datos
                //  4)       Adsn               char        100           cadena de conexion a la base de datos
                //  5)       Atable             char        100           tabla a afectar
                //  6)       ASQLCommand        char        100           comando sql para la seleccion de datos
                //  7)       Aheight            int        25             alto del grid
                //  8)       Awidth             int        25             ancho del grid
                //  9)       Afont              char        25            fuente de las letras
                //  10)       AbackgroundColor   char        25            color del fondo del grid
                //  VALOR RETORNO:   objeto de la clase OmnisoftGrid

                function __construct($Alogo,$Atitle,$AsHeader,$AsFooter,$Afont='Arial',$AtitleFontSize=18,$aFontColor=0xf,$AbackgroundColor=0x0,$ApageSize=35,$ApageOrientation='P',$aAncho=210,$aAlto=148)
                {
                 parent::__construct($ApageOrientation,mm,Array($aAncho,$aAlto));
                 $this->slogo=$Alogo;
                 $this->stitle=$Atitle;
                 $this->stitleFontSize=$AtitleFontSize;
                 $this->sHeader=$AsHeader;
                 $this->sFooter=$AsFooter;
                 $this->sfont=$Afont;
                 $this->sfontColor=$AfontColor;
                 $this->sbackgroundColor=$AbackgroundColor;
                 $this->spageSize=$ApageSize;
                 $this->sfontColor=$AfontColor;
                 $this->spageOrientation=$pageOrientation;
                 $this->columnCount=0;
                 $this->columnDetailCount=0;

                  if ($this->spageOrientation==OMNISOFT_VERTICAL)
                     $this->spageWidth=OMNISOFT_VERTICAL_WIDTH;
                  else
                     $this->spageWidth=OMNISOFT_HORIZONTAL_WIDTH;
                      $this->AliasNbPages();
                      }

                //  NOMBRE:  addColumn
                //  DESCRIIPCIN:  asigna las caracteristicas de la fila actual seleccionada
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Attributes         char        100            atributos de la fila seleccionada
                //  VALOR RETORNO:   ninguno

                function addColumn($AdisplayColumnName, $Awidth=20,$value=0,$posX=0,$posY=0,$Atype="string",$Aalign="left",$Afont='Arial',$Asize='18',$Abold=false,$Apagebreak=false,$fill=0,$AfontcolorR=0,$AfontcolorG=0,$AfontcolorB=0)
                {
                 $this->activeColumnArray[$this->columnCount++]=array(
                                               "idColumn"=>$this->columnCount,
                                               "displayColumnName"=>$AdisplayColumnName,
                                               "width"=>$Awidth,
                                               "type"=>$Atype,
                                               "align"=>$Aalign,
                                               "value"=>$value,
                                               "posX"=>$posX,
                                               "posY"=>$posY,
						"font"=>$Afont,
						"size"=>$Asize,
						"bold"=>$Abold,
						"pagebreak"=>$Apagebreak,
                                                "fontcolorR"=>$AfontcolorR,
                                                "fontcolorG"=>$AfontcolorG,
                                                "fontcolorB"=>$AfontcolorB,
						"fill"=>$fill

                                                );
                     // $this->columnCount++;
                }


                function Header()
                {
                 global $title,$monthDay,$weekDay,$omnisoftCiudad,$dblink,$OMNISOFT_MULTIPLE_LOGO,$OMNISOFT_LOGOS;
                 $this->rsEmpresa=$dblink->Execute('select logotipo_emp,direccion_emp,telefono_emp,web_emp,email_emp from empresa');

                 $serial_sec=$_COOKIE['serial_sec'];
                 if (isset($OMNISOFT_MULTIPLE_LOGO) && $OMNISOFT_MULTIPLE_LOGO)
                 $this->Image('../../fotos/'.$OMNISOFT_LOGOS[$serial_sec],45,0,109,26);
                 else
                  $this->Image('../../fotos/CABECERALIBRETAINICIAL.JPG',2,1,206,18);

                 //$this->Image('../../fotos/'.$this->rsEmpresa->fields[0],45,0,120,25);

                // $this->Image($this->slogo,50,6,109,26);

                 $this->SetFont($this->sfont,'B',$this->stitleFontSize);

                 $w=$this->GetStringWidth($this->stitle)+80;
                 $this->SetX(($this->spageWidth-$w)/2);
                 $this->SetTextColor(0x0,0x0,0x33);

       //          $this->MultiCell(0,10,$this->stitle);

                  $d=$omnisoftCiudad.", ".$weekDay[date("w")]." ".date("d")." de ".$monthDay[date("n")]." del ".date("Y")." a las ".date("H:i:s");
                  $w=$this->GetStringWidth($d);
                  $this->SetX(($this->spageWidth-$w)/2+10);

                 $this->SetFont($this->sfont,'',$this->stitleFontSize-10);
                 //$this->Cell(0,10,$d);
                 $this->Ln();
                 $this->SetDrawColor(0x0,0x0,0x33);
                 //$this->SetLineWidth(0.4); Descomentar para utilizar la imagen logo.jpg

                 $this->SetFont($this->sfont,'B',$this->stitleFontSize-4);
                 $w=$this->GetStringWidth($this->sHeader)+60;
                 $this->SetY(33);
                 $this->SetX(($this->spageWidth-$w)/2-10);
//                 $this->MultiCell(0,10,$this->sHeader);


              //   $this->Line(10,33,280,33);

                }


                function Footer()
                {

            /*     $this->SetDrawColor(0x0,0x0,0x33);
                 $this->SetLineWidth(0.4);

                 $this->Line(10,270,200,270);



                 $this->SetFont($this->sfont,'',$this->stitleFontSize-10);
                  $this->SetY(270);

     //            $this->Cell(0,10,"Pgina ".$this->PageNo()." de ".'{nb}',0,0,'C');
                  $this->Ln();

                 $this->Cell(0,10,$this->sFooter,0,0,'C'); */

                }




function printPage() {

               $this->AddPage();
               $this->SetAutoPageBreak(false);
               $this->SetFont($this->sfont,'',$this->stitleFontSize-12);

               $posX=5;
               $posY=48;
				
               $this->Ln($posY);
               $this->SetFillColor(0x0,0x33,0x99);
               $this->SetTextColor(255);
               $this->SetDrawColor(255);
               $this->SetLineWidth(.3);

               $this->SetFillColor(0xC0,0xC0,0xC0);

               // $this->SetFillColor(224,235,255);
                $this->SetTextColor(0);


                $fill=0;
                $rowno=0;


                       $rx=$posX; $ry=$posY;

                           foreach($this->activeColumnArray as $key => $arrayElement) {
								if ($arrayElement["pagebreak"])
							        $this->AddPage();
			//	 $fill=!$fill;
                             if ($arrayElement["fill"])
                                  $this->SetFillColor(0xC0,0xC0,0xC0);

                             $this->SetY($posY+$arrayElement["posY"]);
                             $this->SetX($posX+$arrayElement["posX"]);

                             if($arrayElement["bold"])
				 $this->SetFont($arrayElement["font"],'B',$arrayElement["size"]);
			else
				$this->SetFont($arrayElement["font"],'',$arrayElement["size"]);
                               $this->SetTextColor($arrayElement["fontcolorR"],$arrayElement["fontcolorG"],$arrayElement["fontcolorB"]);

                             $width=strlen($arrayElement["displayColumnName"])*3;
                             if ($width>$arrayElement["width"]) {
                               $width=$arrayElement["width"];
                             }
                             if ($arrayElement["displayColumnName"]!=' ')
                             $this->Cell($width,3,$arrayElement["displayColumnName"],1,1,'L',0);

                             $width=$arrayElement["width"];
			    // $rec=substr($arrayElement["value"],0,$width);
                               $rec=$arrayElement["value"];

			   $rec=utf8_decode($rec);

                               if (strlen($rec)>0) {
     	//			$this->setFont($arrayElement["font"]," ",$arrayElement["size"]);
                                  $w=$this->GetStringWidth($arrayElement["displayColumnName"]);

                                   $this->SetY($posY+$arrayElement["posY"]);
                                   $this->SetX($posX+$arrayElement["posX"]+$w);

	                              if  ( $arrayElement["type"]=="string")
                                         $this->Cell($arrayElement["width"]-2,3,$rec,'L',1,'L',$fill);
                                  else  if  ( $arrayElement["type"]=="number")
                                         $this->Cell($arrayElement["width"]-2,3,$rec,'R',1,'R',$fill);

                                   else  if  ( $arrayElement["type"]=="line") {
                                               if ($arrayElement["bold"])
                                                   $this->SetDrawColor(0,0,0);
                                               else
                                                     $this->SetDrawColor(0xC0,0xC0,0xC0);
                                                     $this->SetLineWidth($arrayElement["value"]);

                                              $this->Line($posX+$arrayElement["posX"],$posY+$arrayElement["posY"],$posX+$arrayElement["posX"]+$arrayElement["width"],$posY+$arrayElement["posY"]);
                                                             $this->SetDrawColor(255);
                                                             $this->SetLineWidth(.3);

                                  }
                                                                     else  if  ( $arrayElement["type"]=="linev") {
                                               if ($arrayElement["bold"])
                                                   $this->SetDrawColor(0,0,0);
                                               else
                                                     $this->SetDrawColor(0xC0,0xC0,0xC0);
                                                     $this->SetLineWidth($arrayElement["value"]);

                                              $this->Line($posX+$arrayElement["posX"],$posY+$arrayElement["posY"],$posX+$arrayElement["posX"],$posY+$arrayElement["posY"]+$arrayElement["width"]);
                                                             $this->SetDrawColor(255);
                                                             $this->SetLineWidth(.3);

                                  }

                                  else


                                  $this->Image($rec,$posX+$arrayElement["posX"],$posY+$arrayElement["posY"],18,18);
                               }
                            }


}




            function ShowIt() {


            //  $this->printPage();

              $this->Output();
            }

                function Rectangle($x,$y,$w,$h) {
                 $this->SetDrawColor(0x0,0x0,0x33);
                 $this->SetLineWidth(0.4);

                 $this->Line($x,$y,$w,$h);

                }



}
?>
