<?php

  require_once ('../PHPWord.php');
  require_once('../adodb/adodb.inc.php');
  require('../../config/config.inc.php');

  $monthDay=array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
  $weekDay=array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");


//------------------------------------------------------------------------------------------------------------------------
//  NOMBRE: OmnisoftExcel
//  DESCRIPCIN: Clase General para crear una hoja Excel
//------------------------------------------------------------------------------------------------------------------------

   class OmnisoftWord {

               var $SQLCommand;        // Array CHAR, comando sql a ejecutar
               var $resultSet;           // Array OBJECT, resultados de la consulta
               var $dblink;             // OBJECT, enlace base datos
               var $record;             // OBJECT, registro actual
               var $activeColumnArray; // OBJECT, arreglo de todas las columnas
               var $objPHPWord;
               var $objDocument;
               var $filename;
               var $numrows;
               var $numcols;
               var $columnCount=0;                  // INT, numero de columnas

                //  NOMBRE:  OmnisoftRTF
                //  DESCRIIPCIN:  Crea un reporte RTF
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Alogo              char        25            nombre del grid
                //  2)       Atitle              char        25            nombre de la pagina que invoca al grid
                //  3)       Aform              char        25            nombre del formulario de ingreso y edicion de datos
                //  5)       Atable             char        100           tabla a afectar
                //  6)       ASQLCommand        char        100           comando sql para la seleccion de datos
                //  7)       Aheight            int        25             alto del grid
                //  8)       Awidth             int        25             ancho del grid
                //  9)       Afont              char        25            fuente de las letras
                //  10)       AbackgroundColor   char        25            color del fondo del grid
                //  VALOR RETORNO:   objeto de la clase OmnisoftGrid

                function __construct($afilename,$aSQLCommand)
                {

		 $this->filename=$afilename;
                 $this->SQLCommand=$aSQLCommand;
                 $this->connectDB();

                 $this->objPHPWord = new PHPWord();
                 $this->objDocument = $PHPWord->loadTemplate($this->filename);

                }



                //  NOMBRE:  connectDB
                //  DESCRIIPCIN:  despliega el Grid
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Attributes         char        100            atributos de la fila seleccionada
                //  VALOR RETORNO:   ninguno

                function connectDB()
                {
                  global $DBConnection;

                 $this->dblink = NewADOConnection($DBConnection);

                 if (!$this->dblink)
                     die("Error Fatal: NO SE PUEDE CONECTAR A LA BASE DE DATOS");
                  $this->dblink->Execute("SET NAMES utf8");

                }


                                //  NOMBRE:  addColumn
                //  DESCRIIPCIN:  asigna las caracteristicas de la fila actual seleccionada
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Attributes         char        100            atributos de la fila seleccionada
                //  VALOR RETORNO:   ninguno

                function addColumn($AdisplayColumnName,$AtableColumnName, $Awidth=20,$Atype="string",$Aalign="left",$Acalc="",$AbackgroundColor="FFFFFFFF",$Afont="Verdana",$AfontSize=10,$AfontColor="0000000000")
                {
                 $this->activeColumnArray[]=array(
                                               "idColumn"=>$this->columnCount,
                                               "displayColumnName"=>$AdisplayColumnName,
                                               "tableColumnName"=>$AtableColumnName,
                                               "width"=>$Awidth,
                                               "type"=>$Atype,
                                               "align"=>$Aalign,
                                               "calc"=>$Acalc,
                                               "backgroundColor"=>$AbackgroundColor,
                                               "font"=>$Afont,
                                               "fontSize"=>$AfontSize,
                                               "fontColor"=>$AfontColor
                                               );
                      $this->columnCount++;
                }

                function setFontByColumnAndRow($col,$row,$font,$fontSize,$fontColor,$bgColor,$bold) {

                    $this->objPHPExcel->getActiveSheet()->getStyle(chr(65+$col).$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
                    $this->objPHPExcel->getActiveSheet()->getStyle(chr(65+$col).$row)->getFill()->getStartColor()->setARGB($bgColor);
                    $this->objPHPExcel->getActiveSheet()->getStyle(chr(65+$col).$row)->getFont()->setBold($bold)->setName($font)->setSize($fontSize)->getColor()->setRGB($fontColor);
                    $this->objPHPExcel->getActiveSheet()->getStyle(chr(65+$col).$row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

                    $this->objPHPExcel->getActiveSheet()->getStyle(chr(65+$col).$row)->getBorders()->getAllBorders()->setColor(new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_BLACK));


                }


                 function showIt() {


                 $this->resultSet=$this->dblink->Execute($this->SQLCommand);

                 $section = $PHPWord->createSection();

                 $styleTable = array('borderSize'=>6, 'borderColor'=>'006699', 'cellMargin'=>80);
                 $styleFirstRow = array('borderBottomSize'=>18, 'borderBottomColor'=>'0000FF', 'bgColor'=>'66BBFF');

                 $styleCell = array('valign'=>'center');
                 $styleCellBTLR = array('valign'=>'center', 'textDirection'=>PHPWord_Style_Cell::TEXT_DIR_BTLR);

                 $fontStyle = array('bold'=>true, 'align'=>'center');

                 $PHPWord->addTableStyle('myOwnTableStyle', $styleTable, $styleFirstRow);

                 $table = $section->addTable('myOwnTableStyle');

                 $table->addRow(900);

                 $table->addCell(2000, $styleCell)->addText('Row 1', $fontStyle);
                 $table->addCell(2000, $styleCell)->addText('Row 2', $fontStyle);
                 $table->addCell(2000, $styleCell)->addText('Row 3', $fontStyle);
                 $table->addCell(2000, $styleCell)->addText('Row 4', $fontStyle);
                 $table->addCell(500, $styleCellBTLR)->addText('Row 5', $fontStyle);

                 for($i = 1; $i <= 10; $i++) {

                	$table->addRow();
       	                $table->addCell(2000)->addText("Cell $i");
    	                $table->addCell(2000)->addText("Cell $i");
	                $table->addCell(2000)->addText("Cell $i");
 	                $table->addCell(2000)->addText("Cell $i");
 	                $text = ($i % 2 == 0) ? 'X' : '';
 	                $table->addCell(500)->addText($text);

                 }

                $objWriter = PHPWord_IOFactory::createWriter($PHPWord, 'Word2007');
                $objWriter->save('AdvancedTable.docx');

                 $col=0;
                 $row=3;

                 foreach($this->activeColumnArray as $key => $arrayElement)    {

                    $this->objPHPExcel->getActiveSheet()->getColumnDimension(chr(65+$col))->setAutoSize(true);
                    $this->setFontByColumnAndRow($col,$row,'Verdana',10,'FFFFFFFF','FF000080',true);
                    $this->objWorksheet->setCellValueByColumnAndRow($col++, $row,utf8_decode($arrayElement["displayColumnName"]) );

                 }

                 $row++;
                 $this->resultSet->MoveFirst();
                 while (!$this->resultSet->EOF) {

                 $col=0;
                 foreach($this->activeColumnArray as $key => $arrayElement)    {
                   if (($row%2) ==0)
                    $this->setFontByColumnAndRow($col,$row,$arrayElement['font'],$arrayElement['fontSize'],$arrayElement['fontColor'],$arrayElement['backgroundColor'],false);
                   else
                    $this->setFontByColumnAndRow($col,$row,$arrayElement['font'],$arrayElement['fontSize'],$arrayElement['fontColor'],"FFE1E1E1",false);


                   $this->objWorksheet->setCellValueByColumnAndRow($col++, $row,utf8_decode($this->resultSet->fields[$arrayElement["tableColumnName"]]) );
                 }

                  $row++;
                  $this->resultSet->MoveNext();

                 }


                 header('Content-Type: application/vnd.ms-word');
                 header('Content-Disposition: attachment;filename="reporte.docx"');
                 header('Cache-Control: max-age=0');
                 $objWriter=PHPWord_IOFactory::createWriter($objPHPWord,"Word2007");
                 $objWriter->save("php://output");

		 }


}


?>