<?php

  require_once 'PHPWord.php';
  require_once('../adodb/adodb.inc.php');
  require('../../config/config.inc.php');

  $monthDay=array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
  $weekDay=array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");


//------------------------------------------------------------------------------------------------------------------------
//  NOMBRE: OmnisoftExcel
//  DESCRIPCIN: Clase General para crear una hoja Excel
//------------------------------------------------------------------------------------------------------------------------

   class OmnisoftWordGrid {

               var $SQLCommand;        // Array CHAR, comando sql a ejecutar
               var $resultSet;           // Array OBJECT, resultados de la consulta
               var $dblink;             // OBJECT, enlace base datos
               var $record;             // OBJECT, registro actual
               var $activeColumnArray; // OBJECT, arreglo de todas las columnas
               var $objPHPWord;
               var $objDocument;
               var $filename;
               var $columnCount;

                //  NOMBRE:  OmnisoftRTF
                //  DESCRIIPCIN:  Crea un reporte RTF
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Alogo              char        25            nombre del grid
                //  2)       Atitle              char        25            nombre de la pagina que invoca al grid
                //  3)       Aform              char        25            nombre del formulario de ingreso y edicion de datos
                //  5)       Atable             char        100           tabla a afectar
                //  6)       ASQLCommand        char        100           comando sql para la seleccion de datos
                //  7)       Aheight            int        25             alto del grid
                //  8)       Awidth             int        25             ancho del grid
                //  9)       Afont              char        25            fuente de las letras
                //  10)       AbackgroundColor   char        25            color del fondo del grid
                //  VALOR RETORNO:   objeto de la clase OmnisoftGrid

                function __construct($afilename,$aSQLCommand,$aTitle)
                {

		 $this->filename=$afilename;
                 $this->SQLCommand=$aSQLCommand;
                 $this->title=$aTitle;


                 $this->connectDB();

              //   $this->dblink->SetFetchMode(ADODB_FETCH_NUM);

                 $this->objPHPWord = new PHPWord();
                 $this->objDocument = $this->objPHPWord->loadTemplate($this->filename);

                 $this->resultSet='';
                 $this->columnCount=0;


                }



                //  NOMBRE:  connectDB
                //  DESCRIIPCIN:  despliega el Grid
                //  PARMETROS:
                //           NOMBRE             TIPO       LONGITUD         DESCRIPCIN
                //  1)       Attributes         char        100            atributos de la fila seleccionada
                //  VALOR RETORNO:   ninguno

                function connectDB()
                {

                  global $DBConnection;

                 $this->dblink = NewADOConnection($DBConnection);

                 if (!$this->dblink)
                     die("Error Fatal: NO SE PUEDE CONECTAR A LA BASE DE DATOS");
                  $this->dblink->Execute("SET NAMES utf8");


                }

                 function addColumn($AdisplayColumnName,$AtableColumnName, $Awidth=20,$Atype="string",$Aalign="left",$Acalc="",$AbackgroundColor="white")
                {
                 $this->activeColumnArray[]=array(
                                               "idColumn"=>$this->columnCount,
                                               "displayColumnName"=>$AdisplayColumnName,
                                               "tableColumnName"=>$AtableColumnName,
                                               "width"=>$Awidth,
                                               "type"=>$Atype,
                                               "align"=>$Aalign,
                                               "calc"=>$Acalc,
                                               "backgroundColor"=>$AbackgroundColor);
                      $this->columnCount++;
                }






           function showIt() {


                 $this->resultSet=$this->dblink->Execute($this->SQLCommand);
                 //echo $this->SQLCommand;
                // $this->objDocument->setValue('titulo', $this->title);

                 $section = $this->objPHPWord->createSection();

                 $styleTable = array('borderSize'=>6, 'borderColor'=>'006699', 'cellMargin'=>80);
                 $styleFirstRow = array('borderBottomSize'=>18, 'borderBottomColor'=>'0000FF', 'bgColor'=>'66BBFF');

                 $styleCell = array('valign'=>'center');

                 $fontStyle = array('bold'=>true, 'align'=>'center');

                 $this->objPHPWord->addTableStyle('myOwnTableStyle', $styleTable, $styleFirstRow);


                 $table = $section->addTable('myOwnTableStyle');

                 $table->addRow(10);

                 $col=0;
                 $row=5;
                 // desplegar titulos de las columnas
                 foreach($this->activeColumnArray as $key => $arrayElement)    {
                   $table->addCell(2000, $styleCell)->addText(utf8_decode($arrayElement["displayColumnName"]), $fontStyle);

                 }


                 $col=0;
                 $row++;
                 while (!$this->resultSet->EOF ) {

     	           $table->addRow(10);

                   for ($col = 0; $col < $this->columnCount; ++$col) {

                      $table->addCell(2000, $styleCell)->addText(utf8_decode($this->resultSet->fields[$col]), $fontStyle);
    //                  $table->addCell(2000, $styleCell)->addText("test", $fontStyle);

                   }

                      $this->resultSet->MoveNext();

                 }

                 $competences = array(
		        "Developpement"  => array(
		              "JAVA","PHP","HTML"),

		        "Data base"  => array(
		              "ORACLE","MYSQL","DATABASE"),

		        "Framework"  => array(
		              "LIEFRY" ,"STRUTS" ,"NOHETO"
					  )
		);

                 $tables = "<w:tbl>";
		foreach($competences as $cle1 => $valeur1){
			foreach($valeur1 as $cle2=>$valeur2){
				$tables .= "<w:tr>";
				$tables .= "<w:tc><w:p><w:r><w:t>";
				$tables .= "$cle1,$valeur2";
				$tables .= "</w:t></w:r></w:p></w:tc>";
				$tables .= "</w:tr>";
			}
		}
		$tables .= '</w:tbl>';

	//	$this->objDocument->setValue('contenido', $tables	);

                  header('Content-Type: application/vnd.ms-word');
                  header('Content-Disposition: attachment;filename="reporte.docx"');
                  header('Cache-Control: max-age=0');


                  $objWriter=PHPWord_IOFactory::createWriter($this->objPHPWord,"Word2007");
                //  $objWriter=PHPWord_IOFactory::createWriter($this->objDocument,"Word2007");
                  $objWriter->save('php://output');


		 }


}


?>