
//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  TTULO: omnisoftjqxGrid.js
//  DESCRIPCIN: Archivo que contiene la clase omnisoftjqxGrid para la gestion de base de datos
//  FECHA DE CREACIN: 05-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCIN
//  1) ------------- -------------  -------------------------
omnisoftjqxChart=function(aObjName,aTheme, aType,aSQLCommand,aTitle="",aDescription="",aDataFields="",aXAxis="",aValueDescription="",aSeries="",aLegendLayout="") {

  // Database connectivity

   this.source;
   this.dataAdapter;
   this.theme=aTheme;
   this.objName='#'+aObjName;
   this.jqxchart=(typeof aObjName == 'object')? aObjName:$(this.objName);
   this.title=aTitle;
   this.description=aDescription;
   this.type=aType;
   this.xAxis=aXAxis;
   this.valueDescription=aValueDescription;
   this.datafields=aDataFields;
   this.sqlCommand=aSQLCommand;
   this.url="lib/server/omnisoftQueryDataJSON2.php";
   this.series=aSeries;
   this.legendLayout=aLegendLayout;
   this.show= function() {

   var chartObject=this;


	this.source =
		{
			 datatype: "json",
			 datafields: this.datafields,
			url:    "lib/server/omnisoftQueryDataJSON2.php",
                        type:"POST",
                             data:{query:this.sqlCommand}



		};

	   this.dataAdapter = new $.jqx.dataAdapter(this.source,
		{
			autoBind: true,
			async: false,
			downloadComplete: function () { },
			loadComplete: function () { },
			loadError: function () { }
		});


       var settings = {
                title: this.title,
                description: this.description,
                enableAnimations: true,
                showLegend: true,
                legendLayout: this.legendLayout,
                backgroundImage: 'images/btfondogrid.png',
                padding: { left: 5, top: 5, right: 5, bottom: 5 },
                titlePadding: { left: 90, top: 0, right: 0, bottom: 10 },
                source: this.dataAdapter,
                xAxis:
                    {
                        dataField: this.xAxis,
                        unitInterval: 1,
                        axisSize: 'auto',
                        position: 'top',
                       textRotationAngle: -75,

                        tickMarks: {
                            visible: true,
                            interval: 1,
                            color: '#f8fbc8'
                        },
                        gridLines: {
                            visible: true,
                            interval: 1,
                            color: '#f8fbc8'
                        }
                    },
                valueAxis:
                {
                    unitInterval: 5,
                    minValue: 0,
                    maxValue: 10,
                    title: { text: this.valueDescription },
                    labels: { horizontalAlignment: 'right' },
                    tickMarks: { color: '#f8fbc8' }
                },
                colorScheme: 'scheme06',
                seriesGroups:
                    [
                        {
                            type: this.type,
                            showLegend: true,

                             labels: {
                                            visible: true,
                                            verticalAlignment: 'top',
                                            offset: { x: 0, y: 30 }
                                        },
                            enableSeriesToggle: true,
                            columnsGapPercent: 50,
                            seriesGapPercent: 0,
                            series:this.series
                        }
                    ]
            };



		this.jqxchart.jqxChart(settings);

        }




};


