
//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  TTULO: omnisoftjqxDataTable.js
//  DESCRIPCIN: Archivo que contiene la clase omnisoftjqxDataTable para la gestion de base de datos
//  FECHA DE CREACIN: 05-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCIN
//  1) ------------- -------------  -------------------------
function desplegarColumnaDataTable(row, column, value, rowData) {
                              var container = '<div style="width: 100%; height: 100%;">';
                               container+= value;
                              container += "</div>";
                              return container;
 }

function desplegarURLDataTable(row, column, value, rowData) {
	                      var container = '<div style="width: 100%; height: 100%;">';
                              if (value!='')
                               container+="<a href='"+value +"' target='_blank'>"+value+"</a>";

                              container += "</div>";
                              return container;
}


omnisoftjqxDataTable=function(aObjName,gWidth,gHeight,nRows,aTheme, aTable,aKey,aSQLCommand,eTitle,aForm='',pwidth=0,pheight=0,aSelectRowFunction='',gColumnsHeight=45,aNestedGridFunction=null) {

  // Database connectivity

   this.source;
   this.dataAdapter;
   this.params;
   this.objForm=(aForm==undefined)?document.dataForm:aForm;
   this.nRows=nRows;
   this.theme=aTheme;
   this.objName='#'+aObjName;
   this.jqxDataTable=(typeof aObjName == 'object')? aObjName:$(this.objName);
   this.form=aForm;
   this.dialogWidth=pwidth;
   this.dialogHeight=pheight;
   this.omnisoftRows=new Array();
   this.data=new Array();
   this.table=aTable;
   this.key=aKey;
   this.keyvalue=0;
   this.rTitle=(eTitle==undefined)? 'REPORTE' : eTitle;
   this.sqlCommand=aSQLCommand;
   this.selectRowFunction=(aSelectRowFunction==undefined)? '' : aSelectRowFunction;
   this.columnsHeight=(gColumnsHeight==undefined)? 20 : gColumnsHeight;
   this.nestedGridFunction=aNestedGridFunction;
   this.column=new Array();
   this.columnCount=0;

   this.datafield=new Array();
   this.datafieldCount=0;

   this.SQLColumn=new Array();
//   this.buttons=(eButtons==undefined)? Array(true,true,true): eButtons;

   this.actions=Array('SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI');
   this.serial_prc=0;
   this.serial_pfl=0;

   this.width=gWidth;
   this.height=gHeight;
  // this.height='99.9%';
  // this.width='99.9%';

   var top = getPos(document.getElementById(aObjName));




//   if (gHeight!='100%')
//	   this.height=(getContentHeight()+158)-155-top.y;
 //  else
//	   this.height=getContentHeight()-20;



   this.table=aTable;
   this.key=aKey;
   this.filterKey=0;
   this.filtering=false;

//   this.url = "lib/server/omnisoftDataTableJSON.php?query="+this.sqlCommand;
    this.url = "lib/server/omnisoftJSONDataTable.php";

   this.addColumn = function(aLabel,aColumnName,aWidth,aType,aAlign,aRender=null,aAggregate=null,aView='visible') {
    var pwidth=aWidth*10;

       if (aView=='visible')
       if (aAggregate == undefined)
              this.column[this.columnCount++]={ text: aLabel,type:aType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,cellsRenderer:aRender };
       else
               this.column[this.columnCount++]={ text: aLabel,type:aType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,cellsRenderer:aRender ,label:aLabel,aggregates: [{'Suma' :aAggregate }]};



       this.datafield[this.datafieldCount++]={ name: aColumnName, type:aType,label:aLabel};

   }

   this.add=function() {
       var gridObject=this;
      sessionStorage.setItem('action','insert');

      omnisoftDialog(gridObject.form);

      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);

   }

    this.update=function() {
       var gridObject=this;

      sessionStorage.setItem('action','edit');
       var selection = this.jqxDataTable.jqxDataTable('getSelection');
      if (selection[0]==undefined)
         omnisoftShowAlert('Advertencia:  Por favor seleccione un item de la lista para editarlo');
      else {
            omnisoftDialog(gridObject.form);

      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);
    }
   }

   this.delete=function() {
       var gridObject=this;
        var selection = gridObject.jqxDataTable.jqxDataTable('getSelection');


        var rowData = selection[0];
        if (selection.length>0) {
            gridObject.keyvalue=rowData[gridObject.key];
           if (confirm('Desea elimnar el (los) registro(s)?'))
              $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'delete',table:gridObject.table,key:gridObject.key,keyvalue:gridObject.keyvalue },
              success:function(data) {
              if (data.result==0)  {
                  var rows = gridObject.jqxDataTable.jqxDataTable('getRows');
                  var rowindex= rows.indexOf(rowData);
                 gridObject.jqxDataTable.jqxDataTable('deleteRow',rowindex);
                // gridObject.jqxgrid.jqxGrid('updateBoundData');
                 omnisoftShowMessage('Registro eliminado exitosamente!');

              }
              else {
                                omnisoftShowAlert('Error: '+data.message);



              }
              }
             } );
            }
          else omnisoftShowAlert('Advertencia: Por favor seleccione un registro para eliminarlo!');
   }

    this.getRowIndex=function() {
      var selectedrowindex = this.jqxDataTable.jqxDataTable('getSelection');
      if (selectedrowindex.length<0)
        return Array(-1,'');


        return Array(selectedrowindex.length,selectedrowindex[0]);

   }


      this.getSelectedRow=function(){
	       var item;
               var selectedrow = this.jqxDataTable.jqxDataTable('getSelection');
               if (selectedrow.length<=0)
		   return 0;
	       return selectedrow[0];

   }

      this.getSelectedCellValue=function(fieldname){
	       var item;
               var selectedrow = this.jqxDataTable.jqxDataTable('getSelection');
               if (selectedrow.length<=0)
		   return 0;
	//	   alert(fieldname+'='+selectedrow[0][fieldname]);
	       return selectedrow[0][fieldname];

   }



   this.show= function(serial) {

   var dataTableObject=this;

   var dleft=parseInt((window.screen.width-dataTableObject.dialogWidth)/2);
   var dtop=parseInt((window.screen.height-dataTableObject.dialogHeight)/2)-50;

   omnisoftDialogSetSize(dleft,dtop,dataTableObject.dialogWidth,dataTableObject.dialogHeight);




   this.source =  {
                             datatype: "json",
                             datafields:this.datafield,
                             id: serial,
                             url: this.url,
                             type: "POST",
                             root: 'Rows',

                             data:{query:this.sqlCommand},
                             beforeprocessing: function (data) {
                                if (data[0].TotalRows>0)
     				dataTableObject.source.totalrecords = data[0].TotalRows;
				}



                             };

   this.dataAdapter = new $.jqx.dataAdapter(this.source);
   this.params= {  width: this.width,
                   height:this.height,

                source: this.dataAdapter,
                sortable: true,
                rowDetails: (this.nestedGridFunction!=null),
                pageable: true,
                pagerMode: 'advanced',
                serverProcessing: true,
                altRows:true,
                filterMode: 'simple',
                filterable: true,
                selectionMode:'singleRow',
                pageSize:this.nRows,
                columnsHeight:this.columnsHeight,
                pagerButtonsCount: 10,
                localization: localizationobj,
                initRowDetails: this.nestedGridFunction,
                theme: this.theme,
                columns: this.column
              };

              this.jqxDataTable.jqxDataTable(this.params );

              this.rowSelected=function (event) {
                              var row = event.args.row;

              if (dataTableObject.selectRowFunction!='')     {
                 setTimeout(dataTableObject.selectRowFunction(row),0);

              }

              }

              this.jqxDataTable.on('rowClick', this.rowSelected);


   }






};


