

//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  TTULO: omnisoftjqxGrid.js
//  DESCRIPCIN: Archivo que contiene la clase omnisoftjqxGrid para la gestion de base de datos
//  FECHA DE CREACIN: 05-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCIN
//  1) ------------- -------------  -------------------------

function procesarEdicionCabeceraGrid() {
  sessionStorage.setItem('griddetailaction','edit');
}
function procesarEliminacionCabeceraGrid() {
  sessionStorage.setItem('griddetailaction','delete');
}

function procesarEstadoCabeceraGrid() {
  sessionStorage.setItem('griddetailaction','status');
}


     var numberrenderer = function (row, column, value) {
                 return '<div style="text-align: center; margin-top: 3px;">' + (1 + value) + '</div>';
             }

      var headerrendererrotateddetaileditable =function (text, align, columnsheight) {
          return '<div style=" width: 100%;"><div style="display: inline-block; font-weight: bold; float:left; width:10%;" ><div style="width:18px;height:18px;"><a href="#" id="divGridEdicion" onClick="procesarEdicionCabeceraGrid()" alt="Editar titulo del insumo"><img src="images/editar3.png" width="18" height="18" ></a></div><div style="width:18px;height:18px" ></div><div style="width:18px;height:18px;"><a href="#" id="divGridEliminar" onClick="procesarEliminacionCabeceraGrid()" alt="Eliminar insumo"><img src="images/eliminar8.png" width="18" height="18" alt="Eliminar Insumo"></a></div></div><div style="display: inline-block; font-weight: bold; float:left; width:90%; "><div class="rotate">' + text + '</div></div></div>';
        }

      var headerrendererrotateddetail =function (text, align, columnsheight) {
//          return '<div style=" width: 100%;"><div style="display: inline-block; font-weight: bold; float:left; width:10%;" ><div style="width:18px;height:18px;"><a href="#" onClick="procesarEdicionCabeceraGrid()" alt="Editar titulo del insumo"><img src="images/editar3.png" width="18" height="18" ></a></div><div style="width:18px;height:18px" ><a href="#" onClick="procesarEstadoCabeceraGrid()" alt="Estado del parcial"><img src="images/candado3.png" width="18" height="18"></a></div><div style="width:18px;height:18px;"><a href="#" onClick="procesarEliminacionCabeceraGrid()" alt="Eliminar insumo"><img src="images/eliminar8.png" width="18" height="18" alt="Eliminar Insumo"></a></div></div><div style="display: inline-block; font-weight: bold; float:left; width:90%; "><div class="rotate">' + text + '</div></div></div>';
          return '<div style=" width: 100%;"><div style="display: inline-block; font-weight: bold; float:left; width:10%;" ><div style="width:18px;height:18px" ><a href="#" onClick="procesarEstadoCabeceraGrid()" alt="Estado del parcial"><img src="images/candado3.png" width="18" height="18"></a></div></div><div style="display: inline-block; font-weight: bold; float:left; width:90%; "><div class="rotate">' + text + '</div></div></div>';


        }



     var headerrendererrotated =function (text, align, columnsheight) {
            return '<div style=" width: 100%;"><div class="rotate">' + text + '</div></div>';
        }


      var headerrenderernormal =function (text, align, columnsheight) {
            return '<div class="inner">' + text + '</div>';
        }

     function replacer(key, value) {
      if (typeof value === "number") { return String(value); }
      else { return value; }
    }

    var genericValidation= function (cell,value) {
     return true;
    }

    var cellsrenderer = function(row, columnfield, value, defaulthtml, columnproperties) {
    if (!columnproperties.editable) {
        var formattedValue = value;
        if (columnproperties.cellsformat == "yyyy-MM-dd" || columnproperties.columntype == 'datetimeinput') {
            formattedValue = $.jqx.dataFormat.formatdate(formattedValue, columnproperties.cellsformat);
        }
        else if (columnproperties.cellsformat != "") {
            formattedValue = $.jqx.dataFormat.formatnumber(formattedValue, columnproperties.cellsformat);
        }
        return '<div style="height: 100%; background-color: cyan;"><span style="float: ' + columnproperties.cellsalign + '; position: relative; margin: 4px;">' + formattedValue + '</span></div>';
     };
    };



omnisoftjqxGrid=function(aObjName,gWidth,gHeight,nRows,aTheme, aTable,aKey,aSQLCommand,eTitle,aForm='',pwidth=0,pheight=0,aSelectRowFunction='',gRowsHeight=20,aNestedGridFunction=null,aEditable=false,gColumnsHeight=30,aGroups=[]) {

  // Database connectivity
  this.refrescar=true;
   this.source;
   this.dataAdapter;
   this.params;
   this.objForm=(aForm==undefined)?document.dataForm:aForm;
   this.nRows=nRows;
   this.theme=aTheme;
   this.objName='#'+aObjName;
   this.jqxgrid=(typeof aObjName == 'object')? aObjName:$(this.objName);
   this.form=aForm;
   this.dialogWidth=pwidth;
   this.dialogHeight=pheight;
   this.omnisoftRows=new Array();
   this.data=new Array();
   this.table=aTable;
   this.key=aKey;
   this.keyvalue=0;
   this.rTitle=(eTitle==undefined)? 'REPORTE' : eTitle;
   this.sqlCommand=aSQLCommand;
   this.selectRowFunction=(aSelectRowFunction==undefined)? '' : aSelectRowFunction;
   this.rowsHeight=(gRowsHeight==undefined)? 20 : gRowsHeight;
   this.columnsHeight=(gColumnsHeight==undefined)? 20 : gColumnsHeight;

   this.nestedGridFunction=aNestedGridFunction;
   this.column=new Array();
   this.editable=aEditable;
   this.columnCount=1;
   this.groups=aGroups;
   this.groupable=(this.groups.length>0);
   this.datafield=new Array();
   this.datafieldCount=1;

   this.SQLColumn=new Array();
//   this.buttons=(eButtons==undefined)? Array(true,true,true): eButtons;

   this.actions=Array('SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI');
   this.serial_prc=0;
   this.serial_pfl=0;

   this.width=gWidth;
   this.height=gHeight;

    var cssclass = 'jqx-widget-header';
    if (this.theme != '') cssclass += ' jqx-widget-header-' + this.theme;
    this.column[0] = {pinned: true, exportable: false, text: "", columntype: 'number',width:8, cellclassname: cssclass, cellsrenderer: numberrenderer };
    this.datafield[0] = { name: '1' };

   var top = getPos(document.getElementById(aObjName));

   if (gHeight=='100%')
	   this.height=getContentHeight()-20;

   this.table=aTable;
   this.key=aKey;
   this.filterKey=0;
   this.filtering=false;

//   this.url = "lib/server/omnisoftJSON.php?query="+this.sqlCommand;
   this.url = "lib/server/omnisoftJSON.php?query=";
   this.formHeader=function(aTitle) {

    document.write('<table width="100%" cellpadding="0" cellspacing="0" border="0">');
    document.write('<tr>');
    document.write('<td width="120px" background="images/bluebartittle.png" ></td>');
    document.write('<td width="22px" background="images/bluebartittleizq.png" style="background-repeat:no-repeat" ></td>');
    document.write('<td width="300px" height="40px" background="images/bluebartittlehor.png" style="font-family:Verdana, Arial, Helvetica, sans-serif; font-size:16; font-style:bold; color:#ffffff; " ><div align="center">'+aTitle+'</div></td>');
    document.write('<td width="22px" background="images/bluebartittleder.png" style="background-repeat:no-repeat" ></td>');
    document.write('<td  background="images/bluebartittle.png"  ></td>');
    document.write('</tr>');
    document.write('</table>');
   }


this.addColumn = function(aLabel,aColumnName, aWidth,aType,aAlign,aView,aFilterType,aCellFormat,aAggregate,aEditable,aValidation,aCellsRender,aDataAdapter,aPinned,aRotated=false,aSerialField="") {
    var objgrid=this.jqxgrid;
    var pwidth=aWidth*10;
    var    view=(aView=='hidden');
     if (aFilterType==undefined) aFilterType='textbox';
     var editable=(aEditable==undefined)?false:aEditable;
     var pinned=(aPinned==undefined)?false:aPinned;
     var label=aLabel;
     var aggregate=(aAggregate==undefined || aAggregate=='none')?'none':aAggregate;
     var validation=(aValidation==undefined || aValidation=='none')?genericValidation:aValidation;
     var cellFormat=(aCellFormat==undefined || aCellFormat=='none')?'none':aCellFormat;
     //  var label="<center>"+aLabel+"  <input type='checkbox' id='"+aColumnName+"_chk' alt='seleccione el casillero para imprimir' onclick='procesarGridCheckBox(event)' /></center>";

       if (aType=='inputbox')
          this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, datafield: aColumnName, displayfield: aColumnName, width: pwidth, cellsalign: aAlign,hidden:view,label:aLabel,editable:editable,pinned:pinned ,
            createeditor: function (row, value, editor) {
                            editor.jqxInput({source: aDataAdapter,displayMember: 'label',valueMember: 'value', width: pwidth, height: 25 }
                            );

                        } ,

           geteditorvalue: function (row, cellvalue, editor) {
                            var funcion=validation+'('+row+','+editor.val().value+')';
                            eval(funcion);
           return editor.val();
    }
          };
       else
       if (aType=='combobox')
          this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, datafield: aSerialField, displayfield: aColumnName, width: pwidth, cellsalign: aAlign,hidden:view,label:aLabel,editable:editable,validation:validation,pinned:pinned ,
            createeditor: function (row, value, editor) {
                            editor.jqxComboBox({ source: aDataAdapter, displayMember: 'label', valueMember: 'value' });
                        }
          };
       else
       if (aggregate == 'none')
          if (cellFormat != 'none' )
              this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,cellsformat: cellFormat,hidden:view,label:aLabel,editable:editable,validation:validation,pinned:pinned };
          else
              this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,hidden:view,label:aLabel ,editable:editable,validation:validation,pinned:pinned};
       else
            if (cellFormat != 'none')   {
                this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, datafield: aColumnName, width: pwidth,cellsalign:  aAlign, cellsformat: cellFormat, aggregates: [{'Suma': aAggregate }] ,editable:editable ,validation:validation,pinned:pinned }
               }
            else
               this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,hidden:view,label:aLabel,aggregates: [{'Suma' :aAggregate }],editable:editable,validation:validation,pinned:pinned };

	if (!aRotated)
  	   this.column[this.columnCount-1]['renderer']=headerrenderernormal;
	else
	   this.column[this.columnCount-1]['renderer']=aRotated; //headerrendererrotated;

        if(aCellsRender!=undefined &&  aCellsRender!='none')
	 this.column[this.columnCount-1]['cellsrenderer']=aCellsRender;



       if (aType=='textbox')
       this.datafield[this.datafieldCount++]={ name: aColumnName,type:'string',label:aLabel};
       else
       if (aType=='datetimeinput')
            this.datafield[this.datafieldCount++]={ name: aColumnName, type:'date',label:aLabel};
       else
       if (aType=='numberinput')
            this.datafield[this.datafieldCount++]={ name: aColumnName, type:'number',label:aLabel};
       else
       if (aType=='checkbox')
            this.datafield[this.datafieldCount++]={ name: aColumnName, type:'bool',label:aLabel};
       else
       if (aType=='combobox')
            this.datafield[this.datafieldCount++]={ name: aColumnName,value:aSerialField, values: { source: aDataAdapter.records, value: 'value', name: 'label' },label:aLabel};
       else
            this.datafield[this.datafieldCount++]={ name: aColumnName, type:aType,label:aLabel};
}


this.getRowIndex=function() {
     var rowid=-1;
      var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
      if (selectedrowindex==-1)
         this.lastRow();
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (selectedrowindex >= 0 && selectedrowindex < rowscount)
          rowid = this.jqxgrid.jqxGrid('getrowid', selectedrowindex);
    return Array(selectedrowindex,rowid);
   }

   this.getRowData=function(rowindex) {
     return this.jqxgrid.jqxGrid('getrowdata', rowindex);
   }


   this.setRowData=function(rowindex) {

     for (var i=1; i< this.datafieldCount; i++)
       if (document.getElementById(this.datafield[i].name)!=undefined)
       this.jqxgrid.jqxGrid('setcellvalue', rowindex, this.datafield[i].name, document.getElementById(this.datafield[i].name).value);

   }


     this.getFilter=function() {
       var gridObject=this;
       var filterinformation = gridObject.jqxgrid.jqxGrid('getfilterinformation');
       if (filterinformation==undefined || filterinformation.length<=0)
          return '';

    var sparams='&filterscount='+filterinformation.length;
    var i=0;
     for ( i=1; i< filterinformation.length; i++) {
       sparams+='&filterdatafield'+i+'='+ filterinformation[i].filtercolumn;
       sparams+='&filtervalue'+i+'='+ filterinformation[i].filter.getfilters()[0].value.toUpperCase();

     }
     return sparams;
   }

    this.getCheckedFields=function() {
         var gridObject=this;
         var i=0;
         var idcheckedfield='';
         var sjson='[';

         for (i=1; i < gridObject.columnCount; i++)
           if (gridObject.column[i].hidden==false) {
           idcheckedfield=gridObject.column[i].dataField+'_chk';
           if(document.getElementById(idcheckedfield)!=undefined && document.getElementById(idcheckedfield).checked )
           sjson+='{"dataField":"'+ gridObject.column[i].dataField+'", "label":"'+ gridObject.column[i].label+'"},';
         }
         if (sjson=="[")
            return "[]";
         sjson=sjson.substr(0,sjson.length-1);
         sjson+=']';
         return sjson;

    }

     this.rowDataToJSON=function(rowdata) {
        var cname='';
        var sjson='{';
        var curvalue='';

        for (var i=1; i< this.datafieldCount-1; i++)
             if (this.column[i].editable) {
             curvalue=rowdata[this.datafield[i].name];
             if (this.column[i].columntype!='combobox' && this.column[i].columntype!='inputbox')
             sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
             else
             if (this.column[i].columntype=='inputbox') {
//             alert('curvalue'+i+'='+curvalue);
               if (!isNaN(curvalue))

             sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';


             }

             else {
                  var serial='valor'+this.datafield[i].name;
//                  alert(serial+':'+rowdata[serial]);
                  if (rowdata[serial]!=undefined) {
                  curvalue=rowdata[serial];
                  sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
                  }
             }

        }

         if (this.column[i].editable) {
             curvalue=rowdata[this.datafield[i].name];

            sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'"';
         }
         else
         sjson=sjson.substring(0,sjson.length-1);

       sjson+='}';
  //     alert(sjson);
       return sjson;
     }

      this.jsonRowData=function(rowindex) {
      var curdata=this.getRowData(rowindex);
      var curvalue;
      var cname;
     var sjson='{';
     for (var i=1; i< this.datafieldCount-1; i++) {

             cname='#'+this.datafield[i].name;

       if (document.getElementById(this.datafield[i].name)!=undefined && document.getElementById(this.datafield[i].name).className=='dbdata') {
//           if ($(cname).attr('class').indexOf('jqx-combobox')==-1)

          if (document.getElementById(this.datafield[i].name).getAttribute('datatype')!='jqxcombobox')
              curvalue = document.getElementById(this.datafield[i].name).value;
          else {
               //   cname='#'+this.datafield[i].name;
                  curvalue = $(cname).jqxComboBox('val');
           }

                curvalue = curvalue.replace(/"/g,'');

       sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
//       alert(sjson);
       }
       else  if (curdata!=undefined) {
       curvalue=eval('curdata.'+this.datafield[i].name);
      // alert(this.datafield[i].name+' = '+curvalue);
       if (typeof curvalue == 'string' && curvalue!=undefined)
       curvalue = curvalue.replace(/"/g,"");
       sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';

       }
      }

       if (document.getElementById(this.datafield[i].name)!=undefined && document.getElementById(this.datafield[i].name).className=='dbdata')
       sjson+='"'+this.datafield[i].name+'":"'+ document.getElementById(this.datafield[i].name).value+'"';
       else sjson=sjson.substring(0,sjson.length-1);

       sjson+='}';
      // alert(sjson);
     return JSON.parse(sjson);
   }



    this.jsonRowDataDB=function(rowindex) {
     var sjson='{';
     var curvalue="";
     for (var i=1; i< this.datafieldCount; i++)
       if (document.getElementById(this.datafield[i].name)!=undefined && (document.getElementById(this.datafield[i].name).className=='dbdata' || document.getElementById(this.datafield[i].name).className=='autoincrement'))
	  if (document.getElementById(this.datafield[i].name).type=='password')
             sjson+='"'+this.datafield[i].name+'":"md5(\''+ document.getElementById(this.datafield[i].name).value+'\')",';
          else {
                curvalue = document.getElementById(this.datafield[i].name).value;
                curvalue = curvalue.replace(/"/g,'');

             sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
          }
       sjson= sjson.substring(0,sjson.length-1);
       sjson+='}';
     return JSON.parse(sjson);
   }



   this.loadData=function(curdata) {
     var newdata=curdata;

     for (var i=1; i< this.datafieldCount; i++)
                 if (document.getElementById(this.datafield[i].name)!=undefined) {
                 var cmd='newdata.'+this.datafield[i].name+"='"+document.getElementById(this.datafield[i].name).value+"'";
                     eval(cmd);
                }

    return newdata;

   }

   this.setFormReadOnly=function(reading) {
     var objeto;
     var cmd;
     for (var i=1; i< this.datafieldCount; i++)
      if (document.getElementById(this.datafield[i].name)!=undefined) {
          document.getElementById(this.datafield[i].name).readOnly=reading;
          var formfield=document.getElementById(this.datafield[i].name);
          if (formfield.getAttribute("combobox")!=null) {
           objeto=formfield.getAttribute("combobox");
           cmd=objeto+'.setDisabled('+reading+')';
           eval(cmd);
          }


      }
     //this.jqxgrid.jqxGrid({ disabled: !reading});
     this.jqxgrid.jqxGrid({ disabled: false});

   }

   this.insert=function() {
   var gridObject=this;
  if (document.getElementById(gridObject.key)!=null)
   document.getElementById(gridObject.key).value=0;

           var rowindex=gridObject.getRowIndex();
           if (rowindex[1]==-1) {
             rowindex=Array(0,0);
            }



           var newdata=gridObject.jsonRowData(rowindex[0]);

           var insertdata=gridObject.jsonRowDataDB(rowindex[0]);
           var srowdata= JSON.stringify(insertdata);


           $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'insert',table:gridObject.table,rowdata:srowdata,key:gridObject.key },
               success:function(data) {
                // alert('grid'+data);
                var datos=data.split('|');
                if (datos[0]=='')    {
                   gridObject.keyvalue=datos[1];
                   gridObject.jqxgrid.jqxGrid('addrow', null,newdata,'last');
                   omnisoftShowMessage('Registro grabado exitosamente');
                }
                else {
                  //     alert('grid2');
                omnisoftShowAlert('Error: '+datos[0]);
                }
           }
           } );

   }


   this.edit=function(){

   var gridObject=this;
   var rowindex=gridObject.getRowIndex();
   if (rowindex[1]!=-1) {
      var newdata=gridObject.jsonRowData(rowindex[0]);

      var updatedata=gridObject.jsonRowDataDB(rowindex[0]);
      var srowdata= JSON.stringify(updatedata);
      var rowsdata=gridObject.getRowData(rowindex[0]);
      var keyvalue=rowsdata[gridObject.key];

      $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'update',table:gridObject.table,key:gridObject.key,keyvalue:keyvalue,rowdata:srowdata },
         success:function(data) {
           var datos=data.split('|');
        //   alert('grid'+data);
           if (datos[0]=='') {
                  gridObject.jqxgrid.jqxGrid('updaterow', rowindex[1],newdata);
            // omnisoftShowMessage("Registro actualizado exitosamente!");

                 // procesarLista();
           }
           else {
          //   alert('grid');
              omnisoftShowAlert('Error: '+datos[0]);
           }
         }
      } );

    }
    else
                 omnisoftShowMessage('Advertencia: Por favor seleccione un registro para actualizarlo!');

   }


   this.save=function() {
   if ($('#dataForm').jqxValidator('validate'))
   if ( sessionStorage.getItem('action')=='insert')
       this.insert();
   else
 if (sessionStorage.getItem('action')=='edit')
       this.edit();
   }

   this.cancel=function() {
     var gridObject=this;
   //  gridObject.setFormReadOnly(false);
     gridObject.jqxgrid.jqxGrid({ disabled: false});
     $('#dataForm').jqxValidator('hide');

     omnisoftShowMessage('Accion Cancelada!');

    var rowindex=gridObject.getRowIndex();

    if (rowindex[1]==-1) {
       gridObject.jqxgrid.jqxGrid('selectrow', 0);
       rowindex=gridObject.getRowIndex();
    }
    else {
       gridObject.jqxgrid.jqxGrid('selectrow', rowindex[1]);
       rowindex=gridObject.getRowIndex();

    }
    var curdata=gridObject.getRowData(rowindex[0]);
    gridObject.loadData(curdata);

   }

    this.firstRow=function() {
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (rowscount>0)
     this.jqxgrid.jqxGrid('selectrow', 0);
     else alert('Advertencia: No existen registros.');
   }

    this.prevRow=function() {
      var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (selectedrowindex > 0 && selectedrowindex< rowscount)
         this.jqxgrid.jqxGrid('selectrow', selectedrowindex-1);
      else alert('Advertencia: Por favor seleccione un registro.');
   }

    this.nextRow=function() {
      var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (selectedrowindex >= 0 && selectedrowindex+1 < rowscount)
         this.jqxgrid.jqxGrid('selectrow', selectedrowindex+1);
   }

    this.lastRow=function() {
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if ( rowscount>0)
         this.jqxgrid.jqxGrid('selectrow', rowscount);
    //  else alert('Advertencia: No existen registros.');
   }



   this.firstPage=function() {
     this.jqxgrid.jqxGrid('gotopage',1);
   }

    this.lastPage=function() {
     this.jqxgrid.jqxGrid('gotopage',100);
   }

   this.prevPage=function() {
   this.jqxgrid.jqxGrid('gotoprevpage');
   }

   this.nextPage=function() {
   this.jqxgrid.jqxGrid('gotonextpage');
   }

   this.loadDate=function() {
       var gridObject=this;
     var fhoy=new Date();
       var cname;
       for (var i=2; i< gridObject.columnCount; i++)  {
          cname='#'+gridObject.datafield[i].name;
           if ($(cname).attr('datatype')=='date') {


                     var sfecha='#'+gridObject.datafield[i].name;

                     $(sfecha).jqxDateTimeInput({ formatString: 'yyyy-MM-dd',culture: 'es-EC',width: 120, height: 20,value: new Date(fhoy.getFullYear(), fhoy.getMonth(), fhoy.getDate())  });

                     }
       }


   }

   this.add=function() {
       var gridObject=this;
      sessionStorage.setItem('action','insert');
  //    alert(gridObject.form);
      omnisoftDialog(gridObject.form);

//      setTimeout(this.loadDate,500);

      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);

   }

   this.update=function() {
       var gridObject=this;

      sessionStorage.setItem('action','edit');
      omnisoftDialog(gridObject.form);

      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);

   }

   this.selectRow=function() {
	   var gridObject=this;
           var sobjName=gridObject.objName;
              if (omniObj !=undefined)
              setTimeout("omniObj.jqxgrid.jqxGrid('updatebounddata', 'filter','sort')",300);

		var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
                    if (selectedrowindex==-1)  {
                       setTimeout("omniObj.jqxgrid.jqxGrid('updatebounddata', 'filter')",300);

                       gridObject.lastRow();
                    }

               setTimeout(function() {
               var item;
                var message='';
                for (var i=1; i< gridObject.datafieldCount; i++) {
                 item  = gridObject.jqxgrid.jqxGrid('getCell',selectedrowindex, gridObject.datafield[i].name);

                 if (item!=null && document.getElementById(gridObject.datafield[i].name)!=undefined)    {
                    document.getElementById(gridObject.datafield[i].name).value=item.value;
                 }

                }
               },500);

   }

   this.getSelectedCellValue=function(fieldname){
	       var item;
		var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
                 item  = this.jqxgrid.jqxGrid('getCell',selectedrowindex, fieldname);
                 if (item!=undefined)
                 return item.value;
                 else
                 return 0;

   }

   this.delete=function() {
       var gridObject=this;
      var rowindex=gridObject.getRowIndex();
         if (rowindex[1]!=-1) {
             var rowsdata=gridObject.getRowData(rowindex[0]);

             var jsonrowdata = JSON.stringify(rowsdata, replacer);
               jsonrowdata=SString.register(jsonrowdata);
             var keyvalue=rowsdata[gridObject.key];
              if (confirm('Desea eliminar el (los) registro(s)?'))
              $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'delete',table:gridObject.table,key:gridObject.key,keyvalue:keyvalue },

            success:function ( data ) {
               if (data.result==0) {
                 gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');
                 omnisoftShowMessage('Registro eliminado exitosamente!');

              }
              else {
                omnisoftShowAlert('Error: '+data.message);



              }
            }
        })

        .error( function() {
             alert('Advertencia: no se pudo eliminar el registro');
        });
        }
          else alert('Advertencia: Por favor seleccione un registro para eliminarlo!');
  }
   this.filterProcess=function(e) {
         //        if (((e.keyCode==undefined) ? e.which :e.keyCode)==13)
         //         this.search();
                 return true;
   }

   this.search=function() {
      var gridObject=this;

    //-----------------------------

    var filterGroup = new $.jqx.filter();
    filterGroup.operator = 'or';
    var filterGroupNumeric = new $.jqx.filter();
    filterGroupNumeric.operator = 'or';

    var filter_or_operator = 1;
    var filterObj='';
    var filterObjNumeric='';
     var i=0;
    var filtervalue=document.getElementById('gridsearch').value.toUpperCase();

    filterObj = filterGroup.createfilter('stringfilter', filtervalue, 'contains');
    filterObjNumeric = filterGroup.createfilter('numericfilter', filtervalue, 'equal');

    filterGroup.addfilter(filter_or_operator, filterObj);
    filterGroupNumeric.addfilter(filter_or_operator, filterObjNumeric);


     for (i=1; i < gridObject.columnCount; i++)
           if (gridObject.column[i].hidden==false)
           if(gridObject.column[i].filtertype=="number"  )
            gridObject.jqxgrid.jqxGrid('addfilter', gridObject.column[i].dataField, filterGroupNumeric);
           else
            gridObject.jqxgrid.jqxGrid('addfilter', gridObject.column[i].dataField, filterGroup);

    gridObject.jqxgrid.jqxGrid('applyfilters');
    //-----------------------------
    gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');

   }
   this.pdf=function() {
      var gridObject=this;
       gridObject.jqxgrid.jqxGrid('exportdata', 'pdf', 'PDF');

   }

   this.excel=function() {
      var gridObject=this;

      gridObject.jqxgrid.jqxGrid('exportdata', 'xls', 'jqxGrid', true, null, false, 'http://192.168.247.245:8080/senplades-SIPeIP/sipeip/report');
   //    gridObject.jqxgrid.jqxGrid('exportdata', 'xls', 'Excel');


  }



   this.word=function() {
      var gridObject=this;

       gridObject.jqxgrid.jqxGrid('exportdata', 'xls', 'Word');
   }


   this.html=function() {
      var gridObject=this;
    gridObject.jqxgrid.jqxGrid('exportdata', 'html', 'Html');
   }

   this.refresh=function() {
     var gridObject=this;

		gridObject.jqxgrid.jqxGrid('updatebounddata');

   }

   this.show= function(serial) {

   var gridObject=this;

   var dleft=parseInt((window.screen.width-gridObject.dialogWidth)/2);
   var dtop=parseInt((window.screen.height-gridObject.dialogHeight)/2)-20;

  // omnisoftDialogSetSize(dleft,dtop,gridObject.dialogWidth,gridObject.dialogHeight);



   this.source =  {
			     records:[],
                             datatype: "json",
                             datafields:this.datafield,
                             id: serial,
                             url: this.url,
                             root: 'Rows',
                             type:"POST",
                             data:{query:this.sqlCommand},
                             beforeprocessing: function (data) {
                                if (data[0].TotalRows>0)
     				gridObject.source.totalrecords = data[0].TotalRows;
				} ,
        filter: function()
	{
              gridObject.filtering=true;
          //    gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');

	},
	sort: function(datafield, sortdirectior)
	{
	//	gridObject.jqxgrid.jqxGrid('updatebounddata');
	},



/*                pager: function (pagenum, pagesize, oldpagenum) {
                            alert(pagenum);
                    // callback called when a page or page size is changed.
                },  */

                             addrow: function (rowid, rowdata) {
                          //    gridObject.setFormReadOnly(true);
                              if (document.dataForm.action!=undefined)
                                  document.dataForm.action.value="none";
                               gridObject.jqxgrid.jqxGrid('setcellvalue', rowid, gridObject.key, gridObject.keyvalue);
							   gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');

                               omnisoftShowMessage('Registro Insertado exitosamente!');
                                $('#dd').dialog('close');

                             },
                             deleterow: function (rowid) {
                                omnisoftShowMessage('Registro eliminado exitosamente!');

                        //      gridObject.setFormReadOnly(true);

                              if (document.dataForm.action!=undefined)
                                  document.dataForm.action.value="insert";

				gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');


                             },
                             updaterow: function (rowid, rowdata,commit) {
                               if (gridObject.refrescar) {
                             var srowdata=    gridObject.rowDataToJSON(rowdata);
                             var keyvalue=    rowdata[gridObject.key].toString();

			     if (srowdata.length>1)
                             $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'edit',table:gridObject.table,rowdata:srowdata,key:gridObject.key,keyvalue: keyvalue},
                                                  success:function(data) {
						  //	alert(data);
                                                  //prompt('test',data.result);
                                                  if (data.result==0) {
                                             // objGrid.jqxgrid.jqxGrid('updaterow', rowindex[1],newdata);
                                                  //  gridObject.jqxgrid.jqxGrid("updatebounddata", "cells");
                                                   commit(true);

                                                   // omnisoftShowMessage('Registro actualizado exitosamente');

                                                  }
                                                  else
                                                  omnisoftShowAlert('Error: '+data.message);
						  },
                                                     error:function (request, status, error) {
                                          //  var result=jQuery.parseJSON(request.responseText);
                                                    omnisoftShowAlert('Error: no se pudo actualizar el registro'+request.responseText);

                                                  }

                                              } );





                                                           // commit(true);
                             }
                              gridObject.refrescar=true;
                               }
                             };

   this.dataAdapter = new $.jqx.dataAdapter(this.source);
   this.params= {  width: this.width, height:this.height,
                                          rowdetails:true,
                                          initrowdetails: this.nestedGridFunction,
                                          rowdetailstemplate: { rowdetails: "<div id='jqxnestedgrid' style='margin: 0px;'></div>", rowdetailsheight: 320, rowdetailshidden: true },
                                          altrows:true,
                                          source: this.dataAdapter,
                                          columnsresize: true,
                                          clipboard:this.editable,
                                          showfilterrow: false,
                                          filterable: false,
                                          showfiltercolumnbackground:true,
                                          theme: this.theme,
                                          autoshowfiltericon: true,
                                          sortable: false,
                                          pageable: false,
                                          virtualmode: false,
                                          pagesize:100,
					  rowsheight:this.rowsHeight,
					  columnsheight:this.columnsHeight,
					  editable: this.editable,
					  showaggregates: false,
					  showstatusbar: false,
                                          statusbarheight: 25,
                                          localization:  localizationobj,
                                          columnsresize: true,
					 // autorowheight: true,
                                         // autoheight: true,
                                           rendergridrows: function(params){
                                           // alert(params.startindex+","+params.endindex);
                                            return gridObject.dataAdapter.records;
 			                     },

                                /*          render: function(){
		                                  var data = [];
		                               this.collection.each(function(site){
			                            data.push(site.attributes);
	                                   });
		                            this.source.localdata = data;
		                            this.adapter.dataBind();
	                                    this.source.totalrecords = this.collection.meta('filteredSize');

                                        	gridObject.jqxgrid.jqxGrid('updatebounddata');
                                 	} ,*/


                                          ready: function () {
                                               var rowscount = gridObject.jqxgrid.jqxGrid('getdatainformation').rowscount;
                                                   gridObject.jqxgrid.jqxGrid({ pagesizeoptions: ['60', '100', rowscount]});

                                              // omnisoftShowMessage('Cargando datos ....');
                                          },

                                           /*handlekeyboardnavigation: function(event)  {
                                           var key = event.charCode ? event.charCode : event.keyCode ? event.keyCode : 0;
                                           if (key == 13) {
                                              gridObject.filterKey=13;
                                              if (gridObject.filtering==true)  {
                                                 gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');
                                                 gridObject.filtering=false;
                                               }


                                              return true;
                                           }
                                           else if (key == 27) {
                                              gridObject.filterKey=27;
                                                 return true;
                                           }
                                           },*/

                                           groupable:gridObject.groupable,
                                           groups:gridObject.groups,


                                          selectionmode:'multiplecellsadvanced',
                                         // ready: function () {
                                         // gridObject.jqxgrid.jqxGrid('localizestrings', localizationobj);
                                         // },


                                          columns: this.column

                                          };

              if (this.nestedGridFunction==null) {
               this.params['rowdetailstemplate'].rowdetailsheight=0;
               this.params['rowdetailstemplate'].rowdetails='';
              }

              this.jqxgrid.jqxGrid(this.params );

              this.rowSelected=function (event) {
              var item;
              var message='';
              var n=0;

              sessionStorage.setItem('action','edit');
              if (gridObject.form!='') {
              omnisoftDialog(gridObject.form);
               setTimeout(function() {
                //alert(gridObject.columnCount);
                for (var i=1; i< gridObject.columnCount; i++) {
               //  alert(gridObject.datafield[i].name+'='+document.getElementById(gridObject.datafield[i].name).getAttribute('datatype'))
                 item  = gridObject.jqxgrid.jqxGrid('getCell',event.args.rowindex, gridObject.datafield[i].name);
                 if (document.getElementById(gridObject.datafield[i].name)!=undefined)    {
                 if (document.getElementById(gridObject.datafield[i].name).getAttribute('datatype')=='date') {

                     var fecha=(item.value == 'null')? "2017-01-01".split('-'): item.value.split('-');
                     var sfecha='#'+gridObject.datafield[i].name;

                     $(sfecha).jqxDateTimeInput({ formatString: 'yyyy-MM-dd',culture: 'es-EC',width: 120, height: 20,value: new Date(fecha[0], fecha[1]-1, fecha[2])  });

                     }
             //    else if (document.getElementById(gridObject.datafield[i].name).getAttribute('datatype')=='double' || document.getElementById(gridObject.datafield[i].name).getAttribute('datatype')=='integer') {
               //      var numero=(item.value == 'null')? "0": item.value;
                 //    var snumero='#'+gridObject.datafield[i].name;

                   //   $(snumero).jqxNumberInput({ width: 100, height: 20, inputMode: 'simple', spinButtons: false});
                   //   $(snumero).jqxNumberInput('val',item.value);

                 //}
                 else
                 document.getElementById(gridObject.datafield[i].name).value=item.value;
                 }
                }
             },500);
               }
              if (gridObject.selectRowFunction!='')
                 setTimeout(gridObject.selectRowFunction,0);



              }

              this.jqxgrid.bind('rowdoubleclick', this.rowSelected);

   }






};


