
//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  TTULO: omnisoftjqxGrid.js
//  DESCRIPCIN: Archivo que contiene la clase omnisoftjqxGrid para la gestion de base de datos
//  FECHA DE CREACIN: 05-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCIN
//  1) ------------- -------------  -------------------------

omnisoftjqxGridDetail=function(aObjName,aMasterKey,aMasterKeyValue,gWidth,gHeight,nRows,aTheme, aTable,aKey,aSQLCommand,eTitle,aSelectRowFunction,aForm='',aFormWidth=0,gRowsHeight=20,aEditable=false) {

  // Database connectivity

   this.source;
   this.dataAdapter;
   this.params;
   this.objForm=(aForm==undefined)?document.dataForm:document.getElementById(aForm+'PopupWindow');
   this.objFormContainer=(aForm==undefined)?aForm:'#'+aForm+'PopupWindow';
   this.objFormContainer=$(this.objFormContainer);

   this.objFormWidth=aFormWidth;
   this.editrow=-1;
   this.action='none';
   this.nRows=nRows;
   this.theme=aTheme;
   this.objName='#'+aObjName;
   this.jqxgrid=$(this.objName);

   this.masterKey=aMasterKey;
   this.masterKeyValue=aMasterKeyValue;
   this.editable=aEditable;

   this.omnisoftRows=new Array();
   this.data=new Array();
   this.table=aTable;
   this.key=aKey;
   this.keyvalue=0;
   this.rTitle=(eTitle==undefined)? 'REPORTE' : eTitle;
   this.sqlCommand=aSQLCommand;
   this.selectRowFunction=(aSelectRowFunction==undefined)? '' : aSelectRowFunction;
   this.rowsHeight=(gRowsHeight==undefined)? 20 : gRowsHeight;

   this.column=new Array();
   this.columnCount=0;

   this.datafield=new Array();
   this.datafieldCount=0;

   this.SQLColumn=new Array();
//   this.buttons=(eButtons==undefined)? Array(true,true,true): eButtons;

   this.actions=Array('SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI');
   this.serial_prc=0;
   this.serial_pfl=0;

   this.width=gWidth;
   this.height=gHeight;
//   this.width='99.9%';

   var top = getPos(document.getElementById(aObjName));

/*   if (gHeight!='100%')
	   this.height=(getContentHeight()+178)-155-top.y;
   else
	   this.height=getContentHeight();

*/
  /*
	if (document.getElementById('container'))
	{
	   if (gHeight!='100%')
		   this.height=getContentHeight()-top.y+33;
	   else
		   this.height=getContentHeight();
	}else
	   	this.height=gHeight;

*/


   this.table=aTable;
   this.key=aKey;
   this.filterKey=0;
   this.filtering=false;

   this.url = "lib/server/omnisoftJSON.php?query="+this.sqlCommand;

   this.formHeader=function(aTitle) {

    document.write('<table width="100%" cellpadding="0" cellspacing="0" border="0">');
    document.write('<tr>');
    document.write('<td width="120px" background="images/bluebartittle.png" ></td>');
    document.write('<td width="22px" background="images/bluebartittleizq.png" style="background-repeat:no-repeat" ></td>');
    document.write('<td width="300px" height="40px" background="images/bluebartittlehor.png" style="font-family:Verdana, Arial, Helvetica, sans-serif; font-size:16; font-style:bold; color:#ffffff; " ><div align="center">'+aTitle+'</div></td>');
    document.write('<td width="22px" background="images/bluebartittleder.png" style="background-repeat:no-repeat" ></td>');
    document.write('<td  background="images/bluebartittle.png"  ></td>');
    document.write('</tr>');
    document.write('</table>');

   }



   this.addColumn = function(aLabel,aColumnName, aWidth,aType,aAlign,aView,aFilterType,aWritable,aCellFormat,aValue,aMember,aSQLCombo) {


   var objectGrid=this.jqxgrid;
    var pwidth=aWidth*10;
    var    view=(aView=='hidden');
    var writable=(aWritable=='writable');



     if (aFilterType==undefined) aFilterType='textbox';

    var label="<center>"+aLabel+"  <input type='checkbox' id='"+aColumnName+"_chk' alt='seleccione el casillero para imprimir' onclick='procesarGridCheckBox(event)' /></center>";

      if (aType=='combobox') {
           var comboSource =
            {
                 datatype: "json",
                 datafields: [
                     { name: aValue, type: 'string' },
                     { name: aMember, type: 'string' }
                 ],
                 id: aValue,
                 url: "lib/server/omnisoftComboJSON.php",
                 type:"POST",
                             root:"entry",
                             record:"content",
                             processdata: function (data) {
                             data.query = aSQLCombo;
                             } ,
                data: {
                    featureClass: "P",
                    style: "full",
                    maxRows: 150
                }
             };

/*            var comboAdapter = new $.jqx.dataAdapter(comboSource, {
                autoBind: true
            });
*/

           var comboAdapter = new $.jqx.dataAdapter(comboSource,
           {
                    formatData: function (data) {
                        data.name_startsWith = '%';
                        return data;
                    },


    loadServerData: function (serverdata, source, callback) {
        $.ajax({
            dataType: source.datatype,
                             url: "lib/server/omnisoftComboJSON.php",
                             type:"POST",
            data: serverdata,
            success: function (data, status, xhr) {

                var dataArray = new Array();
                var value='';
                for (var i = 0; i < data.length; i++) {
                    var record = data[i];
                    var datarow = {};
                    for (var j = 0; j < source.datafields.length; j++) {
                        var datafield = source.datafields[j];
                        if (undefined == datafield || datafield == null) {
                            continue;
                        }
                        value='record.'+datafield.name;
                       // alert(datafield.name);
                        value=eval(datafield.name+'='+value);
                        datarow[datafield.name] = value;
                    }
                    dataArray[i] = datarow;
                 //   alert(i+'='+dataArray[i].serial_desc+' ,' +dataArray[i].descripcion_dep);
                }
                // send the loaded records to the jqxDataAdapter plug-in.
                callback({ records: dataArray });
            }
        });
    }
}
);









       this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,cellsformat: aCellFormat,hidden:view,label:aLabel,writable:writable,sqlcombo:aSQLCombo,displaymember:aMember,valuemember:aValue,value:0,createeditor: function (row, column, editor) {
                    //        editor.jqxComboBox({ source: comboAdapter, displayMember: aMember ,valueMember:aValue});
                            editor.jqxComboBox({ source: comboAdapter, displayMember: aMember ,valueMember:aValue});


                        },
                        initeditor: function (row, column, editor) {
                          //  editor.jqxComboBox('selectIndex', 3);
                        },
                         geteditorvalue: function (row, cellvalue, editor) {
                                    //alert(aValue+'='+editor.val());
                                    var item=editor.jqxComboBox('getSelectedItem');
                                   // alert(item.label);
                                   // alert(item.value);
                                   // this.value=item.value;
                                     objectGrid.jqxGrid('setcellvalue', row, aValue, item.value);
                                    // alert('row='+row+' campo='+aValue+'valor= '+item.value);
                                     return { 'label': item.label, 'value': item.label}
                          },

                        };

      }
      else

       if (aCellFormat != undefined && aCellFormat != '')
       this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,cellsformat: aCellFormat,hidden:view,label:aLabel,writable:writable };
       else
       this.column[this.columnCount++]={ text: label,columntype:aType,filtertype: aFilterType, dataField: aColumnName, width: pwidth, cellsalign: aAlign,hidden:view,label:aLabel,writable:writable  };

       if (aFilterType=='textbox')
          if (aType=='combobox')
       this.datafield[this.datafieldCount++]={ name: aColumnName,type:aType,label:aLabel,writable:writable,hidden:view};
          else
       this.datafield[this.datafieldCount++]={ name: aColumnName,type:'text',label:aLabel,writable:writable,hidden:view};

       else
       this.datafield[this.datafieldCount++]={ name: aColumnName, type:aFilterType,label:aLabel,writable:writable,hidden:view};


   }

this.getRowIndex=function() {
     var rowid=-1;
      var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
      if (selectedrowindex==-1)
         this.lastRow();
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (selectedrowindex >= 0 && selectedrowindex < rowscount)
          rowid = this.jqxgrid.jqxGrid('getrowid', selectedrowindex);
    return Array(selectedrowindex,rowid);
   }

   this.getRowData=function(rowindex) {
     return this.jqxgrid.jqxGrid('getrowdata', rowindex);
   }


   this.setRowData=function(rowindex) {

     for (var i=0; i< this.datafieldCount; i++)
       if (document.getElementById(this.datafield[i].name)!=undefined)
       this.jqxgrid.jqxGrid('setcellvalue', rowindex, this.datafield[i].name, document.getElementById(this.datafield[i].name).value);

   }


     this.getFilter=function() {
       var gridObject=this;
       var filterinformation = gridObject.jqxgrid.jqxGrid('getfilterinformation');
       if (filterinformation==undefined || filterinformation.length<=0)
          return '';

    var sparams='&filterscount='+filterinformation.length;
    var i=0;
     for ( i=0; i< filterinformation.length; i++) {
       sparams+='&filterdatafield'+i+'='+ filterinformation[i].filtercolumn;
       sparams+='&filtervalue'+i+'='+ filterinformation[i].filter.getfilters()[0].value;

     }
     return sparams;
   }

    this.getCheckedFields=function() {
         var gridObject=this;
         var i=0;
         var idcheckedfield='';
         var sjson='[';

         for (i=0; i < gridObject.columnCount; i++) {
           idcheckedfield=gridObject.column[i].dataField+'_chk';
           if(document.getElementById(idcheckedfield).checked)
           sjson+='{"dataField":"'+ gridObject.column[i].dataField+'", "label":"'+ gridObject.column[i].label+'"},';
         }
         if (sjson=="[")
            return "[]";
         sjson=sjson.substr(0,sjson.length-1);
         sjson+=']';
         return sjson;

    }

     this.loadRowDataForm=function(rowindex) {
      var curdata=this.getRowData(rowindex);
      var curvalue;
       for (var i=0; i< this.datafieldCount; i++)
         if (curdata!=undefined && document.getElementById(this.datafield[i].name)!=undefined) {
             curvalue=eval('curdata.'+this.datafield[i].name);
             document.getElementById(this.datafield[i].name).value=curvalue;
         }
     }




    this.jsonRowData=function(rowindex) {
      var curdata=this.getRowData(rowindex);
      var curvalue;
      var sjson='{';

     for (var i=0; i< this.datafieldCount-1; i++)
       if (curdata!=undefined && this.datafield[i].writable) {
 //        if (this.datafield[i].type=='combobox') {
//             alert('valor='+this.column[i].value);
       curvalue=eval('curdata.'+this.datafield[i].name);
//       curvalue = curvalue.replace(/"/g,"");
       sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
//         }
       }
       if (this.datafield[i].writable) {
       curvalue=eval('curdata.'+this.datafield[i].name);
//       curvalue = curvalue.replace(/"/g,"");
       sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
       }
      sjson+='"'+this.masterKey+'":"'+ this.masterKeyValue+'"';

       sjson+='}';
     return JSON.parse(sjson);
   }

      this.jsonRowDataEmpty=function(rowindex) {
      var curdata=this.getRowData(rowindex);
      var curvalue;
     var sjson='{';
     for (var i=0; i< this.datafieldCount-1; i++)
       if (curdata!=undefined && this.datafield[i].writable) {
         if (this.datafield[i].hidden)
       curvalue=eval('curdata.'+this.datafield[i].name);
       else if (this.datafield[i].type=='text')
               curvalue="";
             else curvalue="0";
//       curvalue = curvalue.replace(/"/g,"");
       sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';

       }
       if (this.datafield[i].writable) {
       curvalue=eval('curdata.'+this.datafield[i].name);
//       curvalue = curvalue.replace(/"/g,"");
       sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
       }
      sjson+='"'+this.masterKey+'":"'+ this.masterKeyValue+'"';

       sjson+='}';
     return JSON.parse(sjson);
   }

    this.setCellsValues=function(rowindex) {
     var curvalue="";

     for (var i=0; i< this.datafieldCount; i++)
      {
            if (document.getElementById(this.datafield[i].name)!=undefined) {
                curvalue = document.getElementById(this.datafield[i].name).value;
                curvalue = curvalue.replace(/"/g,'');
                 this.jqxgrid.jqxGrid('setcellvalue', rowindex, this.datafield[i].name, curvalue);

            }
          }
   }



    this.jsonRowDataForm=function(rowindex) {
     var sjson='{';
     var curvalue="";

     for (var i=0; i< this.datafieldCount; i++)
      {
            if (document.getElementById(this.datafield[i].name)!=undefined) {
                curvalue = document.getElementById(this.datafield[i].name).value;
                curvalue = curvalue.replace(/"/g,'');
                sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
            }
          }
       sjson= sjson.substring(0,sjson.length-1);
       sjson+='}';

     return JSON.parse(sjson);
   }





    this.jsonRowDataDBEmpty=function(rowindex) {
     var sjson='{';
     var curvalue="0";
     for (var i=0; i< this.datafieldCount; i++)
      {      if (this.datafield[i].writable)
             sjson+='"'+this.datafield[i].name+'":"'+ curvalue+'",';
          }

             sjson+='"'+this.masterKey+'":"'+ this.masterKeyValue+'",';

       sjson= sjson.substring(0,sjson.length-1);
       sjson+='}';

     return JSON.parse(sjson);
   }


   this.loadData=function(curdata) {
     var newdata=curdata;

     for (var i=0; i< this.datafieldCount; i++)
                 if (document.getElementById(this.datafield[i].name)!=undefined) {
                 var cmd='newdata.'+this.datafield[i].name+"='"+document.getElementById(this.datafield[i].name).value+"'";
                     eval(cmd);
                }

    return newdata;

   }

   this.setFormReadOnly=function(reading) {
     var objeto;
     var cmd;
     for (var i=0; i< this.datafieldCount; i++)
      if (document.getElementById(this.datafield[i].name)!=undefined) {
          document.getElementById(this.datafield[i].name).readOnly=reading;
          var formfield=document.getElementById(this.datafield[i].name);
          if (formfield.getAttribute("combobox")!=null) {
           objeto=formfield.getAttribute("combobox");
           cmd=objeto+'.setDisabled('+reading+')';
           eval(cmd);
          }


      }
     //this.jqxgrid.jqxGrid({ disabled: !reading});
     this.jqxgrid.jqxGrid({ disabled: false});

   }


   this.insertForm=function(){
   var gridObject=this;

      gridObject.action='insert';
      //gridObject.objFormContainer.reset();
      document.getElementById(gridObject.masterKey).value=gridObject.masterKeyValue;
      alert(gridObject.masterKeyValue);


      var offset = gridObject.jqxgrid.offset();
      gridObject.objFormContainer.jqxWindow({ position: { x: parseInt(offset.left) + 30, y: parseInt(offset.top) - 160 } });
      gridObject.objFormContainer.jqxWindow('open');
      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);

  }



   this.insert=function() {
   var gridObject=this;
   var rowindex=Array(0,0);
   var insertdata=gridObject.jsonRowDataEmpty(rowindex[0]);

         //  var insertdata=gridObject.jsonRowDataDBEmpty(rowindex[0]);
           var srowdata= JSON.stringify(insertdata);

           $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'insert',table:gridObject.table,rowdata:srowdata,key:gridObject.key },
               success:function(data) {
                var datos=data.split('|');
                if (datos[0]=='')    {
                   gridObject.keyvalue=datos[1];
                   gridObject.jqxgrid.jqxGrid('addrow', null,insertdata,'last');
                   alert("Registro creado exitosamente!");
                 //  procesarLista();
                }
                else {
                  alert('Error: '+datos[0]);
                  setMessage('Error: '+datos[0]);

                }
           }
           } );
   }


  this.editForm=function(){
   var gridObject=this;
   var rowindex=gridObject.getRowIndex();

   if (rowindex[1]!=-1) {
      gridObject.loadRowDataForm(rowindex[0]);
      gridObject.action='edit';
      gridObject.editrow = rowindex[1];


      var offset = gridObject.jqxgrid.offset();
      gridObject.objFormContainer.jqxWindow({ position: { x: parseInt(offset.left) + 30, y: parseInt(offset.top) - 160 } });
      gridObject.objFormContainer.jqxWindow('open');
      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);

   }
   else {
        alert('Advertencia: Por favor seleccione un registro para editarlo');
        setMessage('Advertencia: Por favor seleccione un registro para editarlo');
  }

  }


   this.edit=function(){
   var gridObject=this;
   var rowindex=gridObject.getRowIndex();
   if (rowindex[1]!=-1) {
      var newdata=gridObject.jsonRowData(rowindex[0]);
      var srowdata= JSON.stringify(newdata);
      var rowsdata=gridObject.getRowData(rowindex[0]);
      var keyvalue=rowsdata[gridObject.key];
      $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'update',table:gridObject.table,key:gridObject.key,keyvalue:keyvalue,rowdata:srowdata },
         success:function(data) {
           var datos=data.split('|');
           if (datos[0]=='') {
                //  gridObject.jqxgrid.jqxGrid('updaterow', rowindex[1],newdata);
                 // alert("Registro actualizado exitosamente!");
                 // procesarLista();
           }
           else {
            alert('Error: '+datos[0]);
            setMessage('Error: '+datos[0]);
           }
         }
      } );

    }
    else alert('Advertencia: Por favor seleccione un registro para actualizarlo!');

   }

   this.saveForm=function() {
      var gridObject=this;
      var newdata=gridObject.jsonRowDataForm(gridObject.editrow);
      var srowdata= JSON.stringify(newdata);
      var rowsdata=gridObject.getRowData(gridObject.editrow);
      var keyvalue=rowsdata[gridObject.key];
      $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'update',table:gridObject.table,key:gridObject.key,keyvalue:keyvalue,rowdata:srowdata },
         success:function(data) {
           var datos=data.split('|');
           if (datos[0]=='') {
                    gridObject.setCellsValues(gridObject.editrow);
               //   gridObject.jqxgrid.jqxGrid('updaterow', gridObject.editrow,newdata);
                 // alert("Registro actualizado exitosamente!");
                 // procesarLista();

//                 var rowID = this.jqxgrid.jqxGrid('getrowid', editrow);
               //  gridObject.jqxgrid.jqxGrid('updaterow', gridObject.editrow, newdata);
                 gridObject.objFormContainer.jqxWindow('hide');



           }
           else {
            alert('Error: '+datos[0]);
            setMessage('Error: '+datos[0]);
           }
         }
      } );
   }


   this.save=function() {
 //    if (this.objFormContainer.jqxValidator('validate'))
       if (this.action=='insert')
           this.insert();
       else
         if (this.action=='edit')
            this.saveForm();
   }

   this.cancel=function() {
     var gridObject=this;
   //  gridObject.setFormReadOnly(false);
     gridObject.jqxgrid.jqxGrid({ disabled: false});
     gridObject.objFormContainer.jqxValidator('hide');
     gridObject.objFormContainer.jqxWindow('close');


     setMessage('accion cancelada');


   }

    this.firstRow=function() {
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (rowscount>0)
     this.jqxgrid.jqxGrid('selectrow', 0);
     else alert('Advertencia: No existen registros.');
   }

    this.prevRow=function() {
      var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (selectedrowindex > 0 && selectedrowindex< rowscount)
         this.jqxgrid.jqxGrid('selectrow', selectedrowindex-1);
      else alert('Advertencia: Por favor seleccione un registro.');
   }

    this.nextRow=function() {
      var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if (selectedrowindex >= 0 && selectedrowindex+1 < rowscount)
         this.jqxgrid.jqxGrid('selectrow', selectedrowindex+1);
   }

    this.lastRow=function() {
      var rowscount = this.jqxgrid.jqxGrid('getdatainformation').rowscount;
      if ( rowscount>0)
         this.jqxgrid.jqxGrid('selectrow', rowscount);
    //  else alert('Advertencia: No existen registros.');
   }



   this.firstPage=function() {
     this.jqxgrid.jqxGrid('gotopage',1);
   }

    this.lastPage=function() {
     this.jqxgrid.jqxGrid('gotopage',100);
   }

   this.prevPage=function() {
   this.jqxgrid.jqxGrid('gotoprevpage');
   }

   this.nextPage=function() {
   this.jqxgrid.jqxGrid('gotonextpage');
   }



   this.add=function() {
       var gridObject=this;
       gridObject.jqxgrid.jqxGrid('addrow', null,{},'last');


   }

   this.update=function() {
       var gridObject=this;

       if (document.dataForm.action!=undefined) {
          document.dataForm.action.value="edit";
          setAction('editando...');

       }
          gridObject.setFormReadOnly(false);

   }

   this.selectRow=function() {
	   var gridObject=this;
           var sobjName=gridObject.objName;
              if (omniObj !=undefined)
              setTimeout("omniObj.jqxgrid.jqxGrid('updatebounddata', 'filter','sort')",300);

		var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
                    if (selectedrowindex==-1)  {
                       setTimeout("omniObj.jqxgrid.jqxGrid('updatebounddata', 'filter')",300);

                       gridObject.lastRow();
                    }


               var item;
                var message='';

                setAction('visualizando ...');
                for (var i=0; i< gridObject.datafieldCount; i++) {
                 item  = gridObject.jqxgrid.jqxGrid('getCell',selectedrowindex, gridObject.datafield[i].name);

                 if (item!=null && document.getElementById(gridObject.datafield[i].name)!=undefined)    {
                    document.getElementById(gridObject.datafield[i].name).value=item.value;
                 if (document.getElementById(gridObject.datafield[i].name).type!='hidden')
                    message=message+item.value+' | ';

                 }
                 /*if (document.dataForm!=undefined)   {
                     document.dataForm.action.value='edit';
                     gridObject.setFormReadOnly(false);
                 } */

                }
   }

   this.getSelectedCellValue=function(fieldname){
	       var item;
		var selectedrowindex = this.jqxgrid.jqxGrid('getselectedrowindex');
                 item  = this.jqxgrid.jqxGrid('getCell',selectedrowindex, fieldname);
                 if (item!=undefined)
                 return item.value;
                 else
                 return 0;

   }

   this.delete=function() {
       var gridObject=this;
          setAction('eliminando...');

        var selectedrowindex = gridObject.jqxgrid.jqxGrid('getselectedrowindex');
        var rowscount = gridObject.jqxgrid.jqxGrid('getdatainformation').rowscount;
        if (selectedrowindex >= 0 && selectedrowindex < rowscount) {
            var rowid = gridObject.jqxgrid.jqxGrid('getrowid', selectedrowindex);
            var rowdata=gridObject.getRowData(rowid);
            gridObject.keyvalue=rowdata[gridObject.key];
           if (confirm('Desea elimnar el (los) registro(s)?'))
              $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'delete',table:gridObject.table,key:gridObject.key,keyvalue:gridObject.keyvalue },
              success:function(data) {
              var datos=data.split('|');
              if (datos[0]=='')  {
                 procesarLista();
                 gridObject.jqxgrid.jqxGrid('deleterow', rowid);
                 gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');
                 alert('Registro eliminado exitosamente!');

              }
              else {
                   alert('Error: '+datos[0]);
                 setMessage('Error: '+datos[0]);

              }
              }
             } );
            }
          else alert('Advertencia: Por favor seleccione un registro para eliminarlo!');
   }
   this.filterProcess=function(e) {
                 if (((e.keyCode==undefined) ? e.which :e.keyCode)==13)
                  this.search();
                 return true;
   }

   this.search=function() {
      var gridObject=this;

    //-----------------------------

    var filterGroup = new $.jqx.filter();
    filterGroup.operator = 'or';
    var filterGroupNumeric = new $.jqx.filter();
    filterGroupNumeric.operator = 'or';

    var filter_or_operator = 1;
    var filterObj='';
    var filterObjNumeric='';
     var i=0;
    var filtervalue=document.getElementById('gridsearch').value;

    filterObj = filterGroup.createfilter('stringfilter', filtervalue, 'contains');
    filterObjNumeric = filterGroup.createfilter('numericfilter', filtervalue, 'equal');

    filterGroup.addfilter(filter_or_operator, filterObj);
    filterGroupNumeric.addfilter(filter_or_operator, filterObjNumeric);


     for (i=0; i < gridObject.columnCount; i++)
           if (gridObject.column[i].hidden==false)
           if(gridObject.column[i].filtertype=="number"  )
            gridObject.jqxgrid.jqxGrid('addfilter', gridObject.column[i].dataField, filterGroupNumeric);
           else
            gridObject.jqxgrid.jqxGrid('addfilter', gridObject.column[i].dataField, filterGroup);

    gridObject.jqxgrid.jqxGrid('applyfilters');
    //-----------------------------
    gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');

   }
   this.pdf=function() {
      var gridObject=this;
      var sortinformation = gridObject.jqxgrid.jqxGrid('getsortinformation');
      var filterinformation='none';
      var sortcolumn='none';
      var sortdirection='none';
      var fieldsinformation= JSON.stringify(gridObject.column);
      var checkedfields='';
      var attributes='width=1020,height=650,scrollbars=no,resizable=no,toolbar=no,location=no,status=no,menubar=no';

      checkedfields=gridObject.getCheckedFields();
      filterinformation=gridObject.getFilter();
      if (checkedfields=='[]') {
         alert("Advertencia:Por favor seleccione las columnas a imprimir");
         return;
      }
      if (sortinformation.sortcolumn!=undefined) {
        sortcolumn=sortinformation.sortcolumn;
        sortdirection=(sortinformation.sortdirection.ascending)?'ASC':'DESC';
      }
       document.formParameters.query.value=gridObject.sqlCommand;
       document.formParameters.table.value=gridObject.table;
       document.formParameters.sortorder.value=sortdirection;
       document.formParameters.sortdatafield.value=sortcolumn+filterinformation;
       document.formParameters.checkedfields.value=checkedfields;
       document.formParameters.target='javascript:window.open(\'../lib/export/omnisoftPDFGridApp.php\',\'omnisoftPDF\',\''+attributes+'\')';
       document.formParameters.action='lib/export/omnisoftPDFGridApp.php';
       document.formParameters.submit();



   }

   this.excel=function() {
      var gridObject=this;
      var sortinformation = gridObject.jqxgrid.jqxGrid('getsortinformation');
      var filterinformation='none';
      var sortcolumn='none';
      var sortdirection='none';
      var fieldsinformation= JSON.stringify(gridObject.column);
      var checkedfields='';
      var attributes='width=1020,height=650,scrollbars=no,resizable=no,toolbar=no,location=no,status=no,menubar=no';

      checkedfields=gridObject.getCheckedFields();
      filterinformation=gridObject.getFilter();
      if (checkedfields=='[]') {
         alert("Advertencia:Por favor seleccione las columnas a imprimir");
         return;
      }
      if (sortinformation.sortcolumn!=undefined) {
        sortcolumn=sortinformation.sortcolumn;
        sortdirection=(sortinformation.sortdirection.ascending)?'ASC':'DESC';
      }
       document.formParameters.query.value=gridObject.sqlCommand;
       document.formParameters.table.value=gridObject.table;
       document.formParameters.sortorder.value=sortdirection;
       document.formParameters.sortdatafield.value=sortcolumn+filterinformation;
       document.formParameters.checkedfields.value=checkedfields;
       document.formParameters.target='javascript:window.open(\'../lib/export/omnisoftExcelGridApp.php\',\'omnisoftExcel\',\''+attributes+'\')';
       document.formParameters.action='lib/export/omnisoftExcelGridApp.php';
       document.formParameters.submit();


  }



   this.word=function() {
      var gridObject=this;
      var sortinformation = gridObject.jqxgrid.jqxGrid('getsortinformation');
      var filterinformation='none';
      var sortcolumn='none';
      var sortdirection='none';
      var fieldsinformation= JSON.stringify(gridObject.column);
      var checkedfields='';
      var attributes='width=1020,height=650,scrollbars=no,resizable=no,toolbar=no,location=no,status=no,menubar=no';

      checkedfields=gridObject.getCheckedFields();
      filterinformation=gridObject.getFilter();
      if (checkedfields=='[]') {
         alert("Advertencia:Por favor seleccione las columnas a imprimir");
         return;
      }
      if (sortinformation.sortcolumn!=undefined) {
        sortcolumn=sortinformation.sortcolumn;
        sortdirection=(sortinformation.sortdirection.ascending)?'ASC':'DESC';
      }
       document.formParameters.query.value=gridObject.sqlCommand;
       document.formParameters.table.value=gridObject.table;
       document.formParameters.sortorder.value=sortdirection;
       document.formParameters.sortdatafield.value=sortcolumn+filterinformation;
       document.formParameters.checkedfields.value=checkedfields;
       document.formParameters.target='javascript:window.open(\'../lib/export/omnisoftWordGridApp.php\',\'omnisoftWord\',\''+attributes+'\')';
       document.formParameters.action='lib/export/omnisoftWordGridApp.php';
       document.formParameters.submit();


   }
   this.html=function() {
      var gridObject=this;
      var sortinformation = gridObject.jqxgrid.jqxGrid('getsortinformation');
      var filterinformation='none';
      var sortcolumn='none';
      var sortdirection='none';
      var fieldsinformation= JSON.stringify(gridObject.column);

      filterinformation=gridObject.getFilter();

      if (sortinformation.sortcolumn!=undefined) {
        sortcolumn=sortinformation.sortcolumn;
        sortdirection=(sortinformation.sortdirection.ascending)?'ASC':'DESC';
      }


       var query='lib/export/omnisoftHTMLGridApp.php?operation=list&query='+gridObject.sqlCommand+'&table='+gridObject.table+'&sortorder='+sortdirection+'&sortdatafield='+sortcolumn+filterinformation+'&fields='+fieldsinformation;
       var attributes='width=1020,height=650,scrollbars=no,resizable=no,toolbar=no,location=no,status=no,menubar=no';
           omnisoftNewWindow=window.open(query,'',attributes);
           if (window.focus) {omnisoftNewWindow.focus()}

   }



   this.show= function() {
   var gridObject=this;

/*   this.column[this.columnCount]={ text: 'Editar',columntype:'button', dataField: 'edit', width: 120, cellsalign: 'left',hidden:false,label:'Editar',writable:false ,
                                 cellsrenderer: function () {
                                  return "Edit";
                                 },
                                 buttonclick: function (row) {
                     // open the popup window when the user clicks a button.
                     gridObject.editrow = row;
                     var offset = gridObject.jqxgrid.offset();
                     gridObject.objFormContainer.jqxWindow({ position: { x: parseInt(offset.left) + 30, y: parseInt(offset.top) - 160 } });
                     // get the clicked row's data and initialize the input fields.
                     gridObject.objFormContainer.jqxWindow('open');
                 }

    };
  */

   this.source =  {
			     records:[],
                             datatype: "json",
                             datafields:this.datafield,
                             id: 'id',
                             url: this.url,
                             root: 'Rows',
                             beforeprocessing: function (data) {
				gridObject.source.totalrecords = data[0].TotalRows;
				} ,
        filter: function()
	{
              gridObject.filtering=true;
/*              alert(gridObject.filterKey);
              if (gridObject.filterKey==13)  {
                alert('entro');
              gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');
              gridObject.filtering=false;
              } */

	},
	sort: function(datafield, sortdirectior)
	{
		gridObject.jqxgrid.jqxGrid('updatebounddata');
	},



/*                pager: function (pagenum, pagesize, oldpagenum) {
                            alert(pagenum);
                    // callback called when a page or page size is changed.
                },  */

                             addrow: function (rowid, rowdata) {
			      gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');

                              setMessage('Registro Insertado exitosamente!');

                             },
                             deleterow: function (rowid) {
                              setMessage('Registro eliminado exitosamente!');
                              gridObject.setFormReadOnly(true);

                              if (document.dataForm.action!=undefined)
                                  document.dataForm.action.value="insert";

				gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');


                             },
                             updaterow: function (rowid, rowdata,commit) {
                             //  alert(commit);
                               gridObject.edit();
                               commit(true);
                             setMessage('Registro actualizado exitosamente!');
	                        // gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');

                             }
                             };

   this.dataAdapter = new $.jqx.dataAdapter(this.source);


   this.params= {
                  width: this.width, height:this.height,altrows:true,
                                          source: this.dataAdapter,
                                          columnsresize: true,
                                          showfilterrow: true,
                                          filterable: true,
                                          showfiltercolumnbackground:true,
                                          theme: this.theme,
                                          autoshowfiltericon: true,
                                          sortable: true,
                                          pageable: true,
                                          virtualmode: true,
                                          showstatusbar:false,
                                          pagesize:this.rowsHeight,
					  rowsheight:21,
					  editable: this.editable,
					  selectionmode: 'singlerown',
                                          editmode: 'selectedcell',
                                           rendergridrows: function(params){
                                           // alert(params.startindex+","+params.endindex);
                                            return gridObject.dataAdapter.records;
 			                     },








                                /*          render: function(){
		                                  var data = [];
		                               this.collection.each(function(site){
			                            data.push(site.attributes);
	                                   });
		                            this.source.localdata = data;
		                            this.adapter.dataBind();
	                                    this.source.totalrecords = this.collection.meta('filteredSize');

                                        	gridObject.jqxgrid.jqxGrid('updatebounddata');
                                 	} ,*/


                                          ready: function () {
                                               setAction('Cargando datos ...');
                                               setMessage('');
                                               //gridObject.firstRow();
                                          },

                                           handlekeyboardnavigation: function(event)  {
                                           var key = event.charCode ? event.charCode : event.keyCode ? event.keyCode : 0;
                                           if (key == 13) {
                                                gridObject.filterKey=13;
                                              if (gridObject.filtering==true)  {
                                                 gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');
                                                 gridObject.filtering=false;
                                               }
                                               else {
                                                var selectedrowindex = gridObject.jqxgrid.jqxGrid('selectedrowindex');
                                                gridObject.edit();
                                                selectedrowindex+=1;
                                                gridObject.jqxgrid.jqxGrid('selectrow', selectedrowindex);
                                                alert(selectedrowindex);

                                               }


                                              return true;
                                           }
                                           else if (key == 27) {
                                              gridObject.filterKey=27;
                                                 return true;
                                           }
                                           },


                                          columns: this.column

                                          };

              this.jqxgrid.jqxGrid(this.params );

   this.objFormContainer.jqxWindow({
       width: this.objFormWidth, resizable: false,  isModal: true, autoOpen: false, cancelButton: $("#Cancel"), modalOpacity: 0.01
   });


//      var elem = document.getElementById("dataFormDetailPopupWindow").getElementsByTagName("input");

 for (var i=0; i< this.datafieldCount; i++)
       if (document.getElementById(this.datafield[i].name)!=undefined)
          if (this.datafield[i].type!='numberinput')
              $("#"+this.datafield[i].name).jqxInput({ theme: this.theme });
          else
              $("#"+this.datafield[i].name).jqxNumberInput({theme:this.theme,spinMode: 'simple', width: 150, height: 23, min: 0, decimalDigits: 0, spinButtons: true });




   this.objFormContainer.on('open', function () {
    // $("#"+this.datafield[1].name).jqxInput('selectAll');
   });


   $("#Cancel").jqxButton({ theme: this.theme });
   $("#Save").jqxButton({ theme: this.theme });

 $("#Save").click(function () {
/*  if (this.editrow >= 0) {
     var row =    this.jsonRowDataForm();

     var rowID = this.jqxgrid.jqxGrid('getrowid', editrow);
                 this.jqxgrid.jqxGrid('updaterow', rowID, row);
                 this.objFormContainer.jqxWindow('hide');
     }   */
   });
   } //show






}; //gridDetail


