
//------------------------------------------------------------------------------------------------------------------------
//  OCL Omnnisoft Component Library
//  PROYECTO: Librerias para el mantenimiento de base de datos
//  DESARROLLADO POR:  Soluciones Integrales OMNISOFT Cia. Ltda.
//  AUTOR:  Marco Hernan Jarrin Lopez
//  EMAIL:  marco@omnisoft.cc
//  WEBSITE:  http://www.omnisoft.cc
//  VERSION:  3.0
//------------------------------------------------------------------------------------------------------------------------
//  TTULO: omnisoftjqxScheduler.js
//  DESCRIPCIN: Archivo que contiene la clase omnisoftjqxScheduler para la gestion de base de datos
//  FECHA DE CREACIN: 05-Septiembre-2012
//  MODIFICACIONES:
//           FECHA       AUTOR               DESCRIPCIN
//  1) ------------- -------------  -------------------------
function desplegarColumnaScheduler(row, column, value, rowData) {
                              var container = '<div style="width: 100%; height: 100%;">';
                               container+= value;
                              container += "</div>";
                              return container;
 }

 function desplegarCita(data) {
//     var foto=(data.foto_alu=='0' || data.foto_alu=='') ?'SINFOTO.JPG':data.foto_alu;
  //   var imgurl = 'fotos/' + foto;

  //var sfoto='<div id="fotoEstudianteLista" class="imagenCircularPequena" style="background-image: url('+imgurl+')"></div>';


   if (data.appointment.estado_cit_cita == "ACEPTADO")
      data.style = "#00ff00";
   else if (data.appointment.estado_cit_cita == "RECHAZADO")
            data.style = "#ff0000";
  return data;

}


function renderScheduler(data) {
 return data;
}

omnisoftjqxScheduler=function(aObjName,gWidth,gHeight,aTheme, aTable,aKey,aSQLCommand,eTitle,aForm='',arenderAppointment=renderScheduler) {
  // Database connectivity

   this.source;
   this.dataAdapter;
   this.params;
   this.form=(aForm==undefined)?'':aForm;
   this.theme=aTheme;
   this.objName='#'+aObjName;
   this.jqxScheduler=(typeof aObjName == 'object')? aObjName:$(this.objName);
   this.data=new Array();
   this.table=aTable;
   this.key=aKey;
   this.keyvalue=0;
   this.eTitle=eTitle;
   this.sqlCommand=aSQLCommand;
   this.appointmentDataFields="{";
   this.currentTime=new Date();
   this.renderAppointment=arenderAppointment;
   this.selectedIndex=0;


   this.datafield="[";

   this.SQLColumn=new Array();
//   this.buttons=(eButtons==undefined)? Array(true,true,true): eButtons;

   this.actions=Array('SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI','SI');
   this.serial_prc=0;
   this.serial_pfl=0;

   this.width=gWidth;
   this.height=gHeight;

   var top = getPos(document.getElementById(aObjName));

   this.table=aTable;
   this.key=aKey;
   this.filterKey=0;
   this.filtering=false;

   //this.url = "lib/server/omnisoftAgendaJSON.php?query="+this.sqlCommand;
   this.url = "lib/server/omnisoftAgendaJSON.php";

   this.addColumn = function(aLabel,aColumnName,aWidth,aType,aFormat) {

              this.appointmentDataFields+='"'+aColumnName+'":"'+ aColumnName+'",';
              if (aFormat!=undefined)
              this.datafield+='{"name":"'+ aColumnName+'","type":"'+aType+'","format":"'+aFormat+'"},';
	      else
              this.datafield+='{"name":"'+ aColumnName+'","type":"'+aType+'"},';


   }



   this.getSelectedAppointment=function(id) {
       var schedulerObject=this;

      var appointments=   schedulerObject.dataAdapter.records;
       for (var i=0;i<appointments.length;i++)
          if (appointments[i].id==id) {
              schedulerObject.selectedIndex=i;
              return appointments[i];
          }

    return null;
   }


   this.add=function() {
       var gridObject=this;
      sessionStorage.setItem('action','insert');

      omnisoftDialog(gridObject.form);

      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);

   }

    this.update=function() {
       var gridObject=this;

      sessionStorage.setItem('action','edit');
      omnisoftDialog(gridObject.form);

      if (gridObject.selectRowFunction!='')
         setTimeout(gridObject.selectRowFunction,0);

   }

   this.delete=function() {
       var gridObject=this;
        var selectedrowindex = gridObject.jqxgrid.jqxGrid('getselectedrowindex');
        var rowscount = gridObject.jqxgrid.jqxGrid('getdatainformation').rowscount;
        if (selectedrowindex >= 0 && selectedrowindex < rowscount) {
            var rowid = gridObject.jqxgrid.jqxGrid('getrowid', selectedrowindex);
            var rowdata=gridObject.getRowData(rowid);
            var cmd='gridObject.keyvalue=rowdata.'+gridObject.key;
            eval(cmd);
           if (confirm('Desea elimnar el (los) registro(s)?'))
              $.ajax({type:'post', url:"lib/server/omnisoftDataManager.php",data: { operation:'delete',table:gridObject.table,key:gridObject.key,keyvalue:gridObject.keyvalue },
              success:function(data) {
              var datos=data.split('|');
              if (datos[0]=='')  {
                 procesarLista();
                 gridObject.jqxgrid.jqxGrid('deleterow', rowid);
                 gridObject.jqxgrid.jqxGrid('updatebounddata', 'filter','sort');
                 omnisoftShowMessage('Registro eliminado exitosamente!');

              }
              else {
                                omnisoftShowAlert('Error: '+datos[0]);



              }
              }
             } );
            }
          else alert('Advertencia: Por favor seleccione un registro para eliminarlo!');
   }


   this.show= function(serial) {

   var SchedulerObject=this;

   this.appointmentDataFields=this.appointmentDataFields.substring(0,this.appointmentDataFields.length-1);
   this.appointmentDataFields+='}';
   this.appointmentDataFields=JSON.parse(this.appointmentDataFields);

   this.datafield=this.datafield.substring(0,this.datafield.length-1);
   this.datafield+="]";
   this.datafield=JSON.parse(this.datafield);
   var divformulario=this.form;

   this.source =  {
                             dataType: "json",
                             dataFields:this.datafield,
                             type:"POST",
                             id: serial,
                             url: this.url,
                             data:{query:this.sqlCommand}

                             };

   this.dataAdapter = new $.jqx.dataAdapter(this.source);
   localizationobj.agendaAppointmentColumn=this.eTitle;
   localizationobj.editDialogTitleString=this.eTitle;
   localizationobj.editDialogCreateTitleString=this.eTitle;
   localizationobj.contextMenuEditAppointmentString= "Editar "+this.eTitle;
   localizationobj.contextMenuCreateAppointmentString= "Crear "+this.eTitle;
   this.params= {  width: this.width,
                   height:this.height,

                source: this.dataAdapter,
                showLegend:false,
                rowsHeight: 25,
                date: new $.jqx.date(this.currentTime.getFullYear(), this.currentTime.getMonth()+1, this.currentTime.getDate()),
                localization: localizationobj,
                theme: this.theme,
                renderAppointment: this.renderAppointment,
//                resources:
  //              {
    //                colorScheme: "scheme01",
      //              dataField: "tipo_cit",
        //            source: new $.jqx.dataAdapter(this.source)
          //      },
                appointmentDataFields:this.appointmentDataFields,

                view: "weekView",
                views:
                [

                    { type: "dayView", showWeekends: true, timeRuler: { scaleStartHour: 7, scaleEndHour: 15 } },
                    { type: "weekView", showWeekends: true, timeRuler: { scaleStartHour: 7, scaleEndHour: 15 } },
                    { type: "monthView", showWeekends: true, timeRuler: { scaleStartHour: 7, scaleEndHour: 15 } }
                ],

                   editDialogCreate: function (dialog, fields, editAppointment) {
                    // hide repeat option
                    fields.repeatContainer.hide();
                    // hide status option
                    fields.statusContainer.hide();
                    // hide timeZone option
                    fields.timeZoneContainer.hide();
                    // hide color option
                    fields.colorContainer.hide();
                    fields.allDayContainer.hide();
                    fields.resourceContainer.hide();
                    fields.locationContainer.hide();

                   document.getElementById(divformulario).style.visibility='visible';

		    var fnombre='#'+divformulario;

//		    dialog.children().first().after($(fnombre));
//		    dialog=$("#dialogscheduler");
                //    $("#dialogscheduler").children().first().after($(fnombre));
                    fields.subjectContainer.prepend($(fnombre));


                //     alert(fnombre);
                  /*
                     var firstloop=true;
                     $('#scheduler').children('div').each(function () { // loop trough the div's (only first level childs) elements in dialogscheduler
                        if (firstloop) {
                          alert('paso');
                        $("#scheduler").children().first().before($(fnombre));
                         return false;
                        }
                });

                    */
                }


              };

              this.jqxScheduler.jqxScheduler(this.params );




            this.jqxScheduler.on('appointmentDoubleClick', function (event) {
                var args = event.args;
                var appointment = args.appointment;
                if(appointment)
                  sessionStorage.getItem('action','edit');
                else
                  sessionStorage.getItem('action','insert');

           //        var fnombre='#'+divformulario;
            //       alert(fnombre);
              //      document.getElementById(divformulario).style.visibility='visible';
                //   $("#dialogscheduler").children().first().before($(fnombre));

                // appointment fields
                // originalData - the bound data.
                // from - jqxDate object which returns when appointment starts.
                // to - jqxDate objet which returns when appointment ends.
                // status - String which returns the appointment's status("busy", "tentative", "outOfOffice", "free", "").
                // resourceId - String which returns the appointment's resouzeId
                // hidden - Boolean which returns whether the appointment is visible.
                // allDay - Boolean which returns whether the appointment is allDay Appointment.
                // resiable - Boolean which returns whether the appointment is resiable Appointment.
                // draggable - Boolean which returns whether the appointment is resiable Appointment.
                // id - String or Number which returns the appointment's ID.
                // subject - String which returns the appointment's subject.
                // location - String which returns the appointment's location.
                // description - String which returns the appointment's description.
                // tooltip - String which returns the appointment's tooltip.
               // alert("appointmentDoubleClick is raised");
            });


   }






};


