<?php
function calc_daynr($year,$month,$day)
{
  $delsum;
  $temp;

  if ($year == 0 && $month == 0 && $day == 0)
    return (0);				/* Skip errors */

  $delsum= (365 * $year+ 31*($month-1) +$day);
  if ($month <= 2)
      $year--;
  else
    $delsum-=  ($month*4+23)/10;
  $temp= (($year/100+1)*3)/4;

  return ($delsum+$year/4-$temp);
} /* calc_daynr */

	/* Calc weekday from daynr */
	/* Returns 0 for monday, 1 for tuesday .... */

function calc_weekday($daynr,$sunday_first_day_of_week)
{
  //DBUG_ENTER("calc_weekday");
  return ( (($daynr + 5 + ($sunday_first_day_of_week ? 1 : 0)) % 7));
}

   /* Calc workdays like excel */
   /*
      nr of weekends = nr of days / 7
      nr of workdays = nr of days - nr of weekends

      The remainder of the division of nr of days / 7
      could fully or partly comprise a weekend.

      Example:
        12345671234567123456712345671234567123456712345671234567123456712345671234567
                     1234567890123456789 (2 weeks + 5 days)
                     12345678901234 (2 weeks = 14 days )
                     56789          (the remainder of 5 days begins on the same day as
the start date)

      The first line in the table below shows that for a remainder of 6 days, when
starting
      on the first day of the week, there is one weekendday.

      If startday = 7 then there is only 1 weekendday
      If nr of remaining days - (7 - day of week) + 1 =

         < 1  => 0 weekenddays
         = 1  => 1 weekendday
         >1   => 2 weekenddays (a saturday and a sunday)

      Nr of              Nr of    Calculation attempt
      remaining Startday weekend
      days               days

      6 days    day 1     1        7-1=6  6-6+1 = 1  1
      6 days    day 2     2        7-2=5  6-5+1 = 2
      6 days    day 3     2        7-3=4  6-4+1 = 3
      6 days    day 4     2        7-4=3  6-3+1 = 4
      6 days    day 5     2        7-5=2  6-2+1 = 5
      6 days    day 6     2        7-6=1  6-1+1 = 6
      6 days    day 7     1        7-7=0  6-0+1 = 7  1

      5 days    day 1     0        7-1=6  5-6+1 = 0  0
      5 days    day 2     1        7-2=5  5-5+1 = 1  1
      5 days    day 3     2        7-3=4  5-4+1 = 2
      5 days    day 4     2        7-4=3  5-3+1 = 3
      5 days    day 5     2        7-5=2  5-2+1 = 4
      5 days    day 6     2        7-6=1  5-1+1 = 5
      5 days    day 7     1        7-7=0  5-0+1 = 6  1

      4 days    day 1     0
      4 days    day 2     0
      4 days    day 3     1
      4 days    day 4     2
      4 days    day 5     2
      4 days    day 6     2
      4 days    day 7     1

      3 days    day 1     0
      3 days    day 2     0
      3 days    day 3     0
      3 days    day 4     1
      3 days    day 5     2
      3 days    day 6     2
      3 days    day 7     1

      2 days    day 1     0
      2 days    day 2     0
      2 days    day 3     0
      2 days    day 4     0
      2 days    day 5     1
      2 days    day 6     2
      2 days    day 7     1

      1 days    day 1     0
      1 days    day 2     0
      1 days    day 3     0
      1 days    day 4     0
      1 days    day 5     0
      1 days    day 6     1
      1 days    day 7     1
*/

function calc_workdays($y1, $m1, $d1, $y2, $m2, $d2)
{
   $days1    = calc_daynr($y1, $m1, $d1);
   $days2    = calc_daynr($y2, $m2, $d2);
   $nrofdays = $days2 - $days1;

   if ($nrofdays==0) return 1;  // e.g. monday - monday = 1 day

   $neg_nrofdays = ($nrofdays < 0);
   $dayofweek    = calc_weekday(($neg_nrofdays ? $days2 : $days1), 0);

   $nrofdays = abs($nrofdays)+1; // e.g. diff mon-tue = 1, but takes 2 days

   $nrofweekends = floor($nrofdays / 7);
   $mod          = $nrofdays % 7;
   $add          = 0;

   // Correction when the remainder (part of a week)
   // fully or partly comprises a weekend.
   if ($mod)
   {
      if (($dayofweek)==7) $add=1;
      else
      {
         $add = $mod - (7 - $dayofweek) + 1;
         if ($add<0) $add = 0;
         if ($add>1) $add = 2;
      }
   }

   $workdays = $nrofdays - (($nrofweekends*2) + $add);

   return ($neg_nrofdays ? -$workdays : $workdays);
}

   // Print nr of workdays between May 1th, 2007 and Apr 16th, 2007
   //printf("Nr of workdays: %d\n",   calc_workdays(2007, 5, 1, 2007, 4, 16));

   // Print nr of workdays between May 13th, 2007 and May 19th, 2007
//   printf("Nr of workdays: %d\n",   calc_workdays(2007, 5, 13, 2007, 5, 19));

?>