/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.util.Log;
import com.android.tools.fd.runtime.BootstrapApplication;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;

public class IncrementalClassLoader
extends ClassLoader {
    public static final boolean DEBUG_CLASS_LOADING = false;
    private final DelegateClassLoader delegateClassLoader;

    public IncrementalClassLoader(ClassLoader original, String nativeLibraryPath, String codeCacheDir, List<String> dexes) {
        super(original.getParent());
        this.delegateClassLoader = IncrementalClassLoader.createDelegateClassLoader(nativeLibraryPath, codeCacheDir, dexes, original);
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> aClass = this.delegateClassLoader.findClass(className);
        return aClass;
    }

    private static DelegateClassLoader createDelegateClassLoader(String nativeLibraryPath, String codeCacheDir, List<String> dexes, ClassLoader original) {
        String pathBuilder = IncrementalClassLoader.createDexPath(dexes);
        return new DelegateClassLoader(pathBuilder, new File(codeCacheDir), nativeLibraryPath, original);
    }

    private static String createDexPath(List<String> dexes) {
        StringBuilder pathBuilder = new StringBuilder();
        boolean first = true;
        for (String dex : dexes) {
            if (first) {
                first = false;
            } else {
                pathBuilder.append(File.pathSeparator);
            }
            pathBuilder.append(dex);
        }
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("Incremental dex path is " + BootstrapApplication.join('\n', dexes)));
        }
        return pathBuilder.toString();
    }

    private static void setParent(ClassLoader classLoader, ClassLoader newParent) {
        try {
            Field parent = ClassLoader.class.getDeclaredField("parent");
            parent.setAccessible(true);
            parent.set(classLoader, newParent);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader inject(ClassLoader classLoader, String nativeLibraryPath, String codeCacheDir, List<String> dexes) {
        IncrementalClassLoader incrementalClassLoader = new IncrementalClassLoader(classLoader, nativeLibraryPath, codeCacheDir, dexes);
        IncrementalClassLoader.setParent(classLoader, incrementalClassLoader);
        return incrementalClassLoader;
    }

    private static class DelegateClassLoader
    extends BaseDexClassLoader {
        private DelegateClassLoader(String dexPath, File optimizedDirectory, String libraryPath, ClassLoader parent) {
            super(dexPath, optimizedDirectory, libraryPath, parent);
        }

        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class aClass = super.findClass(name);
            return aClass;
        }
    }
}

